# 股权质押统计数据

**文档ID**: 110
**原始链接**: https://tushare.pro/document/2?doc_id=110

---

## 股权质押统计数据

接口：pledge_stat描述：获取股票质押统计数据限量：单次最大1000积分：用户需要至少500积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>截止日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>截止日期</td>
</tr>
<tr>
<td>pledge_count</td>
<td>int</td>
<td>Y</td>
<td>质押次数</td>
</tr>
<tr>
<td>unrest_pledge</td>
<td>float</td>
<td>Y</td>
<td>无限售股质押数量（万）</td>
</tr>
<tr>
<td>rest_pledge</td>
<td>float</td>
<td>Y</td>
<td>限售股份质押数量（万）</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本</td>
</tr>
<tr>
<td>pledge_ratio</td>
<td>float</td>
<td>Y</td>
<td>质押比例</td>
</tr>
</tbody></table>
接口使用

```
pro = ts.pro_api()
#或者
#pro = ts.pro_api('your token')


df = pro.pledge_stat(ts_code='000014.SZ')

```

或者

```

df = pro.query('pledge_stat', ts_code='000014.SZ')

```

数据示例

```
             ts_code  end_date  pledge_count  unrest_pledge  rest_pledge  \
0    000014.SZ  20180928            23          63.16          0.0   
1    000014.SZ  20180921            24          63.17          0.0   
2    000014.SZ  20180914            24          63.17          0.0   
3    000014.SZ  20180907            28          63.69          0.0   
4    000014.SZ  20180831            28          63.69          0.0   
5    000014.SZ  20180824            29          64.74          0.0   
6    000014.SZ  20180817            29          64.74          0.0   
7    000014.SZ  20180810            29          64.74          0.0   
8    000014.SZ  20180803            29          64.74          0.0   
9    000014.SZ  20180727            29          64.74          0.0   
10   000014.SZ  20180720            29          64.74          0.0   
11   000014.SZ  20180713            29          64.74          0.0   
12   000014.SZ  20180706            30          64.77          0.0   
13   000014.SZ  20180629            30          64.77          0.0   
14   000014.SZ  20180622            30          64.77          0.0   
15   000014.SZ  20180615            28          66.50          0.0 
```
