# 股权质押明细数据

**文档ID**: 111
**原始链接**: https://tushare.pro/document/2?doc_id=111

---

## 股权质押明细

接口：pledge_detail描述：获取股票质押明细数据限量：单次最大1000积分：用户需要至少500积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>holder_name</td>
<td>str</td>
<td>Y</td>
<td>股东名称</td>
</tr>
<tr>
<td>pledge_amount</td>
<td>float</td>
<td>Y</td>
<td>质押数量（万股）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>Y</td>
<td>质押开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>质押结束日期</td>
</tr>
<tr>
<td>is_release</td>
<td>str</td>
<td>Y</td>
<td>是否已解押</td>
</tr>
<tr>
<td>release_date</td>
<td>str</td>
<td>Y</td>
<td>解押日期</td>
</tr>
<tr>
<td>pledgor</td>
<td>str</td>
<td>Y</td>
<td>质押方</td>
</tr>
<tr>
<td>holding_amount</td>
<td>float</td>
<td>Y</td>
<td>持股总数（万股）</td>
</tr>
<tr>
<td>pledged_amount</td>
<td>float</td>
<td>Y</td>
<td>质押总数（万股）</td>
</tr>
<tr>
<td>p_total_ratio</td>
<td>float</td>
<td>Y</td>
<td>本次质押占总股本比例</td>
</tr>
<tr>
<td>h_total_ratio</td>
<td>float</td>
<td>Y</td>
<td>持股总数占总股本比例</td>
</tr>
<tr>
<td>is_buyback</td>
<td>str</td>
<td>Y</td>
<td>是否回购（0否 1是）</td>
</tr>
</tbody>
</table>
接口使用

```
pro = ts.pro_api()
#或者
#pro = ts.pro_api('your token')


df = pro.pledge_detail(ts_code='000014.SZ')

```

或者

```
df = pro.query('pledge_detail', ts_code='000014.SZ')

```

数据示例

```
             ts_code  ann_date         holder_name          pledge_amount start_date  \
0  000014.SZ  20180106  中科汇通(深圳)股权投资基金有限公司       500.0000   20171114   
1  000014.SZ  20180106  中科汇通(深圳)股权投资基金有限公司       922.0055   20171114   
2  000014.SZ  20171221  中科汇通(深圳)股权投资基金有限公司       600.0000   20171114   
3  000014.SZ  20171216  中科汇通(深圳)股权投资基金有限公司       300.0000   20171114   
4  000014.SZ  20171111  中科汇通(深圳)股权投资基金有限公司       2321.9955   20151127   
5  000014.SZ  20170616  中科汇通(深圳)股权投资基金有限公司       0.0100   20151127   
6  000014.SZ  20060927  深圳市沙河实业(集团)有限公司             1936.3698   20050119

```
