# 股东人数

**文档ID**: 166
**原始链接**: https://tushare.pro/document/2?doc_id=166

---

## 股东人数

接口：stk_holdernumber描述：获取上市公司股东户数数据，数据不定期公布限量：单次最大3000,总量不限制积分：600积分可调取，基础积分每分钟调取100次，5000积分以上频次相对较高。具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期</td>
</tr>
<tr>
<td>enddate</td>
<td>str</td>
<td>N</td>
<td>截止日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>截止日期</td>
</tr>
<tr>
<td>holder_num</td>
<td>int</td>
<td>Y</td>
<td>股东户数</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

df = pro.stk_holdernumber(ts_code='300199.SZ', start_date='20160101', end_date='20181231')

```

数据示例

```
      ts_code  ann_date  end_date  holder_num
0   300199.SZ  20181025  20180930       25135
1   300199.SZ  20180808  20180630       25785
2   300199.SZ  20180426  20180331       23384
3   300199.SZ  20180316  20180228       23490
4   300199.SZ  20180316  20171231       24086
5   300199.SZ  20171026  20170930       24121
6   300199.SZ  20170817  20170630       26271
7   300199.SZ  20170427  20170331       24531
8   300199.SZ  20170427  20161231       22972
9   300199.SZ  20161028  20161027       19787
10  300199.SZ  20161027  20160930       19787
11  300199.SZ  20160804  20160630       20050
12  300199.SZ  20160428  20160331       23367

```
