# 美股资产负债表

**文档ID**: 395
**原始链接**: https://tushare.pro/document/2?doc_id=395

---

## 美股资产负债表

接口：us_balancesheet，可以通过数据工具调试和查看数据。描述：获取美股上市公司资产负债表（目前只覆盖主要美股和中概股）权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期（格式：YYYYMMDD，每个季度最后一天的日期，如20241231)</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>N</td>
<td>指标名(如：新增借款）</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告期类型(Q1一季报Q2半年报Q3三季报Q4年报)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始时间（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束始时间（格式：YYYYMMDD）</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>ind_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型(Q1一季报Q2半年报Q3三季报Q4年报)</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>Y</td>
<td>财务科目名称</td>
</tr>
<tr>
<td>ind_value</td>
<td>float</td>
<td>Y</td>
<td>财务科目值</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型</td>
</tr>
</tbody>
</table>
接口用法

```
pro = ts.pro_api()

#获取美股英伟达NVDA股票Q4的资产负债表数据
df = pro.us_balancesheet(ts_code='NVDA', report_type='Q4')

#获取美股英伟达NVDA股票历年应收帐款指标数据
df = pro.us_balancesheet(ts_code='NVDA', ind_name='应收帐款')

```

数据样例

```
         ts_code  end_date ind_type name     ind_name     ind_value report_type
0       NVDA  20250427       Q1  英伟达    负债及股东权益合计  1.252540e+11         一季报
1       NVDA  20250427       Q1  英伟达       股东权益合计  8.384300e+10         一季报
2       NVDA  20250427       Q1  英伟达   归属于母公司股东权益  8.384300e+10         一季报
3       NVDA  20250427       Q1  英伟达       其他综合收益  1.860000e+08         一季报
4       NVDA  20250427       Q1  英伟达         股本溢价  1.147500e+10         一季报
...      ...       ...      ...  ...          ...           ...         ...
2459    NVDA  20060129       Q4  英伟达     预付款项(流动)  2.438700e+07          年报
2460    NVDA  20060129       Q4  英伟达  递延所得税资产(流动)  2.682000e+06          年报
2461    NVDA  20060129       Q4  英伟达           存货  2.548700e+08          年报
2462    NVDA  20060129       Q4  英伟达         应收账款  3.181860e+08          年报
2463    NVDA  20060129       Q4  英伟达     现金及现金等价物  5.517560e+08          年报

```
