# 美股财务指标数据

**文档ID**: 393
**原始链接**: https://tushare.pro/document/2?doc_id=393

---

## 美股财务指标数据

接口：us_fina_indicator，可以通过数据工具调试和查看数据。描述：获取美股上市公司财务指标数据，目前只覆盖主要美股和中概股。为避免服务器压力，现阶段每次请求最多返回200条记录，可通过设置日期多次请求获取更多数据。权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期（格式：YYYYMMDD，每个季度最后一天的日期，如20241231)</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告期类型(Q1一季报Q2半年报Q3三季报Q4年报)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始时间（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束始时间（格式：YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>ind_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型,Q1一季报,Q2中报,Q3三季报,Q4年报</td>
</tr>
<tr>
<td>security_name_abbr</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>accounting_standards</td>
<td>str</td>
<td>Y</td>
<td>会计准则</td>
</tr>
<tr>
<td>notice_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>Y</td>
<td>报告期开始时间</td>
</tr>
<tr>
<td>std_report_date</td>
<td>str</td>
<td>Y</td>
<td>标准报告期</td>
</tr>
<tr>
<td>financial_date</td>
<td>str</td>
<td>Y</td>
<td>年结日</td>
</tr>
<tr>
<td>currency</td>
<td>str</td>
<td>Y</td>
<td>币种</td>
</tr>
<tr>
<td>date_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型</td>
</tr>
<tr>
<td>operate_income</td>
<td>float</td>
<td>Y</td>
<td>收入</td>
</tr>
<tr>
<td>operate_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>收入增长</td>
</tr>
<tr>
<td>gross_profit</td>
<td>float</td>
<td>Y</td>
<td>毛利</td>
</tr>
<tr>
<td>gross_profit_yoy</td>
<td>float</td>
<td>Y</td>
<td>毛利增长</td>
</tr>
<tr>
<td>parent_holder_netprofit</td>
<td>float</td>
<td>Y</td>
<td>归母净利润</td>
</tr>
<tr>
<td>parent_holder_netprofit_yoy</td>
<td>float</td>
<td>Y</td>
<td>归母净利润增长</td>
</tr>
<tr>
<td>basic_eps</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益</td>
</tr>
<tr>
<td>diluted_eps</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益</td>
</tr>
<tr>
<td>gross_profit_ratio</td>
<td>float</td>
<td>Y</td>
<td>销售毛利率</td>
</tr>
<tr>
<td>net_profit_ratio</td>
<td>float</td>
<td>Y</td>
<td>销售净利率</td>
</tr>
<tr>
<td>accounts_rece_tr</td>
<td>float</td>
<td>Y</td>
<td>应收账款周转率(次)</td>
</tr>
<tr>
<td>inventory_tr</td>
<td>float</td>
<td>Y</td>
<td>存货周转率(次)</td>
</tr>
<tr>
<td>total_assets_tr</td>
<td>float</td>
<td>Y</td>
<td>总资产周转率(次)</td>
</tr>
<tr>
<td>accounts_rece_tdays</td>
<td>float</td>
<td>Y</td>
<td>应收账款周转天数</td>
</tr>
<tr>
<td>inventory_tdays</td>
<td>float</td>
<td>Y</td>
<td>存货周转天数</td>
</tr>
<tr>
<td>total_assets_tdays</td>
<td>float</td>
<td>Y</td>
<td>总资产周转天数</td>
</tr>
<tr>
<td>roe_avg</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率</td>
</tr>
<tr>
<td>roa</td>
<td>float</td>
<td>Y</td>
<td>总资产净利率</td>
</tr>
<tr>
<td>current_ratio</td>
<td>float</td>
<td>Y</td>
<td>流动比率(倍)</td>
</tr>
<tr>
<td>speed_ratio</td>
<td>float</td>
<td>Y</td>
<td>速动比率(倍)</td>
</tr>
<tr>
<td>ocf_liqdebt</td>
<td>float</td>
<td>Y</td>
<td>经营业务现金净额/流动负债</td>
</tr>
<tr>
<td>debt_asset_ratio</td>
<td>float</td>
<td>Y</td>
<td>资产负债率</td>
</tr>
<tr>
<td>equity_ratio</td>
<td>float</td>
<td>Y</td>
<td>产权比率</td>
</tr>
<tr>
<td>basic_eps_yoy</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益同比增长</td>
</tr>
<tr>
<td>gross_profit_ratio_yoy</td>
<td>float</td>
<td>Y</td>
<td>毛利率同比增长(%)</td>
</tr>
<tr>
<td>net_profit_ratio_yoy</td>
<td>float</td>
<td>Y</td>
<td>净利率同比增长(%)</td>
</tr>
<tr>
<td>roe_avg_yoy</td>
<td>float</td>
<td>Y</td>
<td>平均净资产收益率同比增长(%)</td>
</tr>
<tr>
<td>roa_yoy</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率同比增长(%)</td>
</tr>
<tr>
<td>debt_asset_ratio_yoy</td>
<td>float</td>
<td>Y</td>
<td>资产负债率同比增长(%)</td>
</tr>
<tr>
<td>current_ratio_yoy</td>
<td>float</td>
<td>Y</td>
<td>流动比率同比增长(%)</td>
</tr>
<tr>
<td>speed_ratio_yoy</td>
<td>float</td>
<td>Y</td>
<td>速动比率同比增长(%)</td>
</tr>
<tr>
<td>currency_abbr</td>
<td>str</td>
<td>Y</td>
<td>币种</td>
</tr>
<tr>
<td>total_income</td>
<td>float</td>
<td>Y</td>
<td>收入总额</td>
</tr>
<tr>
<td>total_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>收入总额同比增长</td>
</tr>
<tr>
<td>premium_income</td>
<td>float</td>
<td>Y</td>
<td>保费收入</td>
</tr>
<tr>
<td>premium_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>保费收入同比</td>
</tr>
<tr>
<td>basic_eps_cs</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益</td>
</tr>
<tr>
<td>basic_eps_cs_yoy</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益同比增长</td>
</tr>
<tr>
<td>diluted_eps_cs</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益</td>
</tr>
<tr>
<td>payout_ratio</td>
<td>float</td>
<td>Y</td>
<td>保费收入/赔付支出</td>
</tr>
<tr>
<td>capitial_ratio</td>
<td>float</td>
<td>Y</td>
<td>总资产周转率</td>
</tr>
<tr>
<td>roe</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率</td>
</tr>
<tr>
<td>roe_yoy</td>
<td>float</td>
<td>Y</td>
<td>净资产收益率同比增长</td>
</tr>
<tr>
<td>debt_ratio</td>
<td>float</td>
<td>Y</td>
<td>资产负债率</td>
</tr>
<tr>
<td>debt_ratio_yoy</td>
<td>float</td>
<td>Y</td>
<td>资产负债率同比增长</td>
</tr>
<tr>
<td>net_interest_income</td>
<td>float</td>
<td>Y</td>
<td>净利息收入</td>
</tr>
<tr>
<td>net_interest_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>净利息收入增长</td>
</tr>
<tr>
<td>diluted_eps_cs_yoy</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益增长</td>
</tr>
<tr>
<td>loan_loss_provision</td>
<td>float</td>
<td>Y</td>
<td>贷款损失准备</td>
</tr>
<tr>
<td>loan_loss_provision_yoy</td>
<td>float</td>
<td>Y</td>
<td>贷款损失准备增长</td>
</tr>
<tr>
<td>loan_deposit</td>
<td>float</td>
<td>Y</td>
<td>贷款/存款</td>
</tr>
<tr>
<td>loan_equity</td>
<td>float</td>
<td>Y</td>
<td>贷款/股东权益(倍)</td>
</tr>
<tr>
<td>loan_assets</td>
<td>float</td>
<td>Y</td>
<td>贷款/总资产</td>
</tr>
<tr>
<td>deposit_equity</td>
<td>float</td>
<td>Y</td>
<td>存款/股东权益(倍)</td>
</tr>
<tr>
<td>deposit_assets</td>
<td>float</td>
<td>Y</td>
<td>存款/总资产</td>
</tr>
<tr>
<td>rol</td>
<td>float</td>
<td>Y</td>
<td>贷款回报率</td>
</tr>
<tr>
<td>rod</td>
<td>float</td>
<td>Y</td>
<td>存款回报率</td>
</tr>
</tbody></table>
注：输出指标太多可在接口fields参数设定你需要的指标，例如：fields='ts_coe,bps,basic_eps'

接口用法

```

pro = ts.pro_api()

#获取美股英伟达NVDA股票2024年度的财务指标数据
df = pro.us_fina_indicator(ts_code='NVDA', period='20241231')

#获取美股英伟达NVDA股票历年年报财务指标数据
df = pro.us_fina_indicator(ts_code='NVDA', report_type='Q4')

```

数据样例

```
     ts_code  end_date ind_type security_name_abbr accounting_standards notice_date start_date std_report_date financial_date currency date_type report_type  operate_income  operate_income_yoy  \
0     NVDA  20250427       Q1                英伟达               美国会计准则    20250528   20250127        20250331            2-1       美元       单季报     2025/Q1    4.406200e+10             69.1829   
1     NVDA  20250126       Q4                英伟达               美国会计准则    20250226   20240129        20241231           1-26       美元        年报     2024/FY    1.304970e+11            114.2034   
2     NVDA  20241027       Q3                英伟达               美国会计准则    20241120   20240129        20240930           1-26       美元      累计季报     2024/Q9    9.116600e+10            134.8489   
3     NVDA  20240728       Q2                英伟达               美国会计准则    20240828   20240129        20240630           1-26       美元      累计季报     2024/Q6    5.608400e+10            170.9503   
4     NVDA  20240428       Q1                英伟达               美国会计准则    20250528   20240129        20240331           1-26       美元       单季报     2024/Q1    2.604400e+10            262.1246   
5     NVDA  20240128       Q4                英伟达               美国会计准则    20250226   20230130        20231231           1-28       美元        年报     2023/FY    6.092200e+10            125.8545   
6     NVDA  20231029       Q3                英伟达               美国会计准则    20241120   20230130        20230930           1-28       美元      累计季报     2023/Q9    3.881900e+10             85.5327   
7     NVDA  20230730       Q2                英伟达               美国会计准则    20240828   20230131        20230630           1-28       美元      累计季报     2023/Q6    2.069900e+10             38.0670   
8     NVDA  20230430       Q1                英伟达               美国会计准则    20240529   20230130        20230331           1-28       美元       单季报     2023/Q1    7.192000e+09            -13.2239   
9     NVDA  20230129       Q4                英伟达               美国会计准则    20250226   20220131        20221231           1-29       美元        年报     2022/FY    2.697400e+10              0.2229   
10    NVDA  20221030       Q3                英伟达               美国会计准则    20231121   20220131        20220930           1-29       美元      累计季报     2022/Q9    2.092300e+10              8.5725   
11    NVDA  20220731       Q2                英伟达               美国会计准则    20230828   20220201        20220630           1-29       美元      累计季报     2022/Q6    1.499200e+10             23.2084   
12    NVDA  20220501       Q1                英伟达               美国会计准则    20230526   20220131        20220331           1-29       美元       单季报     2022/Q1    8.288000e+09             46.4052   
13    NVDA  20220130       Q4                英伟达               美国会计准则    20240221   20210201        20211231           1-30       美元        年报     2021/FY    2.691400e+10             61.4033   
14    NVDA  20211031       Q3                英伟达               美国会计准则    20221118   20210201        20210930           1-30       美元      累计季报     2021/Q9    1.927100e+10             65.1045   

```
