# 美股日线行情

**文档ID**: 254
**原始链接**: https://tushare.pro/document/2?doc_id=254

---

## 美股行情

接口：us_daily描述：获取美股行情（未复权），包括全部股票全历史行情，以及重要的市场和估值指标限量：单次最大6000行数据，可根据日期参数循环提取，开通正式权限后也可支持分页提取全部历史要求：120积分可以试用查看数据，开通正式权限请参考权限说明文档。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码（e.g. AAPL）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期（YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期（YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>N</td>
<td>涨跌额</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>vwap</td>
<td>float</td>
<td>Y</td>
<td>平均价</td>
</tr>
<tr>
<td>turnover_ratio</td>
<td>float</td>
<td>N</td>
<td>换手率</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>N</td>
<td>总市值</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>N</td>
<td>PE</td>
</tr>
<tr>
<td>pb</td>
<td>float</td>
<td>N</td>
<td>PB</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取单一股票行情
df = pro.us_daily(ts_code='AAPL', start_date='20190101', end_date='20190904')

#获取某一日所有股票
df = pro.us_daily(trade_date='20190904')

```

数据示例

```
    ts_code trade_date   close    open    high     low pre_close pct_change       vol              amount    vwap
0      AAPL   20190904  209.19  208.39  209.48  207.32    205.70       1.70  19216821   4008342529.970000  208.59
1      AAPL   20190903  205.70  206.43  206.98  204.22    208.74      -1.46  20059575   4120106317.760000  205.39
2      AAPL   20190830  208.74  210.16  210.45  207.20    209.01      -0.13  21162563   4410472824.780000  208.41
3      AAPL   20190829  209.01  208.50  209.32  206.66    205.53       1.69  21007653   4380322743.230000  208.51
4      AAPL   20190828  205.53  204.10  205.72  203.32    204.16       0.67  15957633   3269889907.950000  204.91
..      ...        ...     ...     ...     ...     ...       ...        ...       ...                 ...     ...
165    AAPL   20190108  150.75  149.56  151.82  148.52    147.93       1.91  41025313   6159076907.780000  150.13
166    AAPL   20190107  147.93  148.70  148.83  145.90    148.26      -0.22  54777766   8071925608.900000  147.36
167    AAPL   20190104  148.26  144.53  148.55  143.80    142.19       4.27  58607071   8605786116.450000  146.84
168    AAPL   20190103  142.19  143.98  145.72  142.00    157.92      -9.96  91312188  13108586866.810000  143.56
169    AAPL   20190102  157.92  154.89  158.85  154.23    157.74       0.11  37039739   5814198206.330000  156.97

```
