# 美股复权因子

**文档ID**: 402
**原始链接**: https://tushare.pro/document/2?doc_id=402

---

## 美股复权因子

接口：us_adjfactor描述：获取美股每日复权因子数据，在每天美股收盘后滚动刷新限量：单次最大15000行数据，可以根据日期循环权限：本接口是在开通美股日线权限后自动获取权限，权限请参考权限说明文档

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所</td>
</tr>
<tr>
<td>cum_adjfactor</td>
<td>float</td>
<td>Y</td>
<td>累计复权因子</td>
</tr>
<tr>
<td>close_price</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取美股单一股票复权因子
df = pro.us_adjfactor(ts_code='AAPL', start_date='20240101', end_date='20251022')

#获取美股某一日全部股票的复权因子
df = pro.us_adjfactor(trade_date='20251031')

```

数据示例

```
      ts_code trade_date exchange cum_adjfactor close_price
0       TAGOF   20251031      OTC      1.000000        None
1        BABA   20251031      NYS      1.000000  170.430000
2         CZR   20251031      NAS      1.000000   20.100000
3        DEEP   20251031      ARC      1.000000   35.025100
4        AVAL   20251031      NYS      1.000000    4.220000
...       ...        ...      ...           ...         ...
14995   MRETF   20251031      OTC      1.000000    7.150000
14996     CHI   20251031      NAS      1.000000   11.390000
14997    TBHC   20251031      NAS      1.000000    1.510000
14998   MQMIF   20251031      OTC      1.000000    0.127600
14999     TAC   20251031      NYS      1.000000   17.670000

```
