# 美股基础信息

**文档ID**: 252
**原始链接**: https://tushare.pro/document/2?doc_id=252

---

## 美股列表

接口：us_basic描述：获取美股列表信息限量：单次最大6000，可分页提取积分：120积分可以试用，5000积分有正式权限

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
<th>示例</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
<td>AAPL（苹果）</td>
</tr>
<tr>
<td>classify</td>
<td>str</td>
<td>N</td>
<td>股票分类</td>
<td>ADR/GDR/EQ</td>
</tr>
<tr>
<td>offset</td>
<td>str</td>
<td>N</td>
<td>开始行数</td>
<td>1：第一行</td>
</tr>
<tr>
<td>limit</td>
<td>str</td>
<td>N</td>
<td>每页最大行数</td>
<td>500：每页500行</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>美股代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>中文名称</td>
</tr>
<tr>
<td>enname</td>
<td>str</td>
<td>N</td>
<td>英文名称</td>
</tr>
<tr>
<td>classify</td>
<td>str</td>
<td>Y</td>
<td>分类ADR/GDR/EQ</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
<tr>
<td>delist_date</td>
<td>str</td>
<td>Y</td>
<td>退市日期</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取默认美国股票基础信息，单次6000行
df = pro.us_basic()


```

数据示例

```
     ts_code  name classify list_date delist_date
0       ONCY  None      EQT  20011005        None
1       SCCO  None      EQT  19950124        None
2      KAOCF  None      EQT  19740319        None
3      BOIRF  None      EQT  19880628        None
4      SDXOF  None      EQT  19830304        None
...      ...   ...      ...       ...         ...
5995   ESESQ  None      EQT  20031014        None
5996    TRKX  None      EQT  20000718        None
5997   ELAMF  None      EQT  19960320        None
5998    CZNB  None      EQT  20120724        None
5999   CRRSQ  None      EQT  20010619        None
```
