# 美股利润表

**文档ID**: 394
**原始链接**: https://tushare.pro/document/2?doc_id=394

---

## 美股利润表

接口：us_income，可以通过数据工具调试和查看数据。描述：获取美股上市公司财务利润表数据（目前只覆盖主要美股和中概股）权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期（格式：YYYYMMDD，每个季度最后一天的日期，如20241231)</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>N</td>
<td>指标名(如：新增借款）</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告期类型(Q1一季报Q2半年报Q3三季报Q4年报)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始时间（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束始时间（格式：YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>ind_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型(Q1一季报Q2半年报Q3三季报Q4年报)</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>Y</td>
<td>财务科目名称</td>
</tr>
<tr>
<td>ind_value</td>
<td>float</td>
<td>Y</td>
<td>财务科目值</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取美股英伟达NVDA股票的2024年度利润表数据
df = pro.us_income(ts_code='NVDA', period='20241231')

#获取美股英伟达NVDA股票利润表历年营业额数据
df = pro.us_income(ts_code='NVDA', ind_name='营业额')

```

数据样例

```
         ts_code  end_date ind_type name       ind_name     ind_value report_type
0       NVDA  20250427       Q1  英伟达          非运算项目  2.271500e+10         单季报
1       NVDA  20250427       Q1  英伟达         全面收益总额  1.893300e+10         单季报
2       NVDA  20250427       Q1  英伟达      其他全面收益合计项  1.580000e+08         单季报
3       NVDA  20250427       Q1  英伟达     其他全面收益其他项目  1.580000e+08         单季报
4       NVDA  20250427       Q1  英伟达  本公司拥有人占全面收益总额  1.893300e+10         单季报
...      ...       ...      ...  ...            ...           ...         ...
1929    NVDA  20050501       Q1  英伟达           营销费用  4.805800e+07         单季报
1930    NVDA  20050501       Q1  英伟达           研发费用  8.591300e+07         单季报
1931    NVDA  20050501       Q1  英伟达             毛利  2.101530e+08         单季报
1932    NVDA  20050501       Q1  英伟达           营业成本  3.736930e+08         单季报
1933    NVDA  20050501       Q1  英伟达           营业收入  5.838460e+08         单季报

```
