# 美股交易日历

**文档ID**: 253
**原始链接**: https://tushare.pro/document/2?doc_id=253

---

## 美股交易日历

接口：us_tradecal描述：获取美股交易日历信息限量：单次最大6000，可根据日期阶段获取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
<th>示例</th>
</tr>
</thead>
<tbody><tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
<td>20200101</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
<td>20200701</td>
</tr>
<tr>
<td>is_open</td>
<td>str</td>
<td>N</td>
<td>是否交易</td>
<td>0：休市 、1：交易</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>cal_date</td>
<td>str</td>
<td>Y</td>
<td>日历日期</td>
</tr>
<tr>
<td>is_open</td>
<td>int</td>
<td>Y</td>
<td>是否交易 '0'休市 '1'交易</td>
</tr>
<tr>
<td>pretrade_date</td>
<td>str</td>
<td>Y</td>
<td>上一个交易日</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.us_tradecal(start_date='20200101', end_date='20200701')


```

数据示例

```
     cal_date  is_open pretrade_date
0    20200701        1      20200630
1    20200630        1      20200629
2    20200629        1      20200626
3    20200628        0      20200625
4    20200627        0      20200625
..        ...      ...           ...
178  20200105        0      20200102
179  20200104        0      20200102
180  20200103        1      20200102
181  20200102        1      20191231
182  20200101        0      20191230
```
