# 管理层薪酬和持股

**文档ID**: 194
**原始链接**: https://tushare.pro/document/2?doc_id=194

---

## 管理层薪酬和持股

接口：stk_rewards描述：获取上市公司管理层薪酬和持股积分：用户需要2000积分才可以调取，5000积分以上频次相对较高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码，支持单个或多个代码输入</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>截止日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>姓名</td>
</tr>
<tr>
<td>title</td>
<td>str</td>
<td>Y</td>
<td>职务</td>
</tr>
<tr>
<td>reward</td>
<td>float</td>
<td>Y</td>
<td>报酬</td>
</tr>
<tr>
<td>hold_vol</td>
<td>float</td>
<td>Y</td>
<td>持股数</td>
</tr>
</tbody></table>
接口用例

```

pro = ts.pro_api()

#获取单个公司高管全部数据
df = pro.stk_rewards(ts_code='000001.SZ')

#获取多个公司高管全部数据
df = pro.stk_rewards(ts_code='000001.SZ,600000.SH')

```

数据样例

```
     ts_code    ann_date  end_date      name     title     reward  hold_vol
0    000001.SZ  20190808  20190630  谢永林       董事长        NaN       0.0
1    000001.SZ  20190808  20190630  胡跃飞     董事,行长        NaN    4104.0
2    000001.SZ  20190808  20190630  陈心颖        董事        NaN       0.0
3    000001.SZ  20190808  20190630   姚波        董事        NaN       0.0
4    000001.SZ  20190808  20190630  叶素兰        董事        NaN       0.0
5    000001.SZ  20190808  20190630  韩小京      独立董事        NaN       0.0
6    000001.SZ  20190808  20190630  蔡方方        董事        NaN       0.0
7    000001.SZ  20190808  20190630   郭建        董事        NaN       0.0
8    000001.SZ  20190808  20190630  郭世邦    董事,副行长        NaN       0.0
9    000001.SZ  20190808  20190630  王春汉      独立董事        NaN       0.0
10   000001.SZ  20190808  20190630  王松奇      独立董事        NaN       0.0
11   000001.SZ  20190808  20190630  郭田勇      独立董事        NaN       0.0
12   000001.SZ  20190808  20190630  杨如生      独立董事        NaN       0.0
13   000001.SZ  20190808  20190630   邱伟  监事长,职工监事        NaN       0.0
14   000001.SZ  20190808  20190630  车国宝      股东监事        NaN       0.0
15   000001.SZ  20190808  20190630  周建国      外部监事        NaN       0.0
16   000001.SZ  20190808  20190630  骆向东      外部监事        NaN       0.0
17   000001.SZ  20190808  20190630  储一昀      外部监事        NaN       0.0
18   000001.SZ  20190808  20190630  孙永桢      职工监事        NaN       0.0
```
