# 神奇九转指标

**文档ID**: 364
**原始链接**: https://tushare.pro/document/2?doc_id=364

---

## 神奇九转指标

接口：stk_nineturn（由于涉及分钟数据每天21点更新）描述：神奇九转（又称“九转序列”）是一种基于技术分析的股票趋势反转指标，其思想来源于技术分析大师汤姆·迪马克（Tom DeMark）的TD序列。该指标的核心功能是通过识别股价在上涨或下跌过程中连续9天的特定走势，来判断股价的潜在反转点，从而帮助投资者提高抄底和逃顶的成功率，日线级别配合60min的九转效果更好，数据从20230101开始。限量：单次提取最大返回10000行数据，可通过股票代码和日期循环获取全部数据权限：达到6000积分可以调用

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （格式：YYYY-MM-DD HH:MM:SS)</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>N</td>
<td>频率(日daily)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始时间</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束时间</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>datetime</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>频率(日daily)</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>up_count</td>
<td>float</td>
<td>Y</td>
<td>上九转计数</td>
</tr>
<tr>
<td>down_count</td>
<td>float</td>
<td>Y</td>
<td>下九转计数</td>
</tr>
<tr>
<td>nine_up_turn</td>
<td>str</td>
<td>Y</td>
<td>是否上九转)+9表示上九转</td>
</tr>
<tr>
<td>nine_down_turn</td>
<td>str</td>
<td>Y</td>
<td>是否下九转-9表示下九转</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df=pro.stk_nineturn(ts_code='000001.SZ',freq='daily',fields='ts_code,trade_date,freq,up_count,down_count,nine_up_turn,nine_down_turn')

```

数据样例

```
    ts_code           trade_date     freq  up_count  down_count nine_up_turn nine_down_turn
0    000001.SZ  2025-01-17 00:00:00  daily       3.0         0.0         None           None
1    000001.SZ  2025-01-16 00:00:00  daily       2.0         0.0         None           None
2    000001.SZ  2025-01-15 00:00:00  daily       1.0         0.0         None           None
3    000001.SZ  2025-01-14 00:00:00  daily       0.0         3.0         None           None
4    000001.SZ  2025-01-13 00:00:00  daily       0.0         2.0         None           None
..         ...                  ...    ...       ...         ...          ...            ...
491  000001.SZ  2023-01-09 00:00:00  daily       1.0         0.0         None           None
492  000001.SZ  2023-01-06 00:00:00  daily       0.0         0.0         None           None
493  000001.SZ  2023-01-05 00:00:00  daily       0.0         0.0         None           None
494  000001.SZ  2023-01-04 00:00:00  daily       0.0         0.0         None           None
495  000001.SZ  2023-01-03 00:00:00  daily       0.0         0.0         None           None

```
