# 社融增量（月度）

**文档ID**: 310
**原始链接**: https://tushare.pro/document/2?doc_id=310

---

## 社融数据（月度）

接口：sf_month描述：获取月度社会融资数据限量：单次最大2000条数据，可循环提取积分：需2000积分

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>m</td>
<td>str</td>
<td>N</td>
<td>月份（YYYYMM，下同），支持多个月份同时输入，逗号分隔</td>
</tr>
<tr>
<td>start_m</td>
<td>str</td>
<td>N</td>
<td>开始月份</td>
</tr>
<tr>
<td>end_m</td>
<td>str</td>
<td>N</td>
<td>结束月份</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>month</td>
<td>str</td>
<td>Y</td>
<td>月度</td>
</tr>
<tr>
<td>inc_month</td>
<td>float</td>
<td>Y</td>
<td>社融增量当月值（亿元）</td>
</tr>
<tr>
<td>inc_cumval</td>
<td>float</td>
<td>Y</td>
<td>社融增量累计值（亿元）</td>
</tr>
<tr>
<td>stk_endval</td>
<td>float</td>
<td>Y</td>
<td>社融存量期末值（万亿元）</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.sf_month(start_m='201901', end_m='202307')


```

数据样例

```
     month inc_month inc_cumval stk_endval
0   202307   5282.00  220800.00     365.77
1   202306  42241.00  215487.00     365.45
2   202305  15555.00  173246.00     361.42
3   202304  12253.00  157691.00     359.95
4   202303  53862.00  145438.00     359.02
5   202302  31623.00   91576.00     353.97
6   202301  59953.00   59953.00     350.93
7   202212  13058.00  320099.00     344.21
8   202211  19837.00  307041.00     343.19
9   202210   9134.00  287204.00     341.42
10  202209  35411.00  278070.00     340.65
11  202208  24712.00  242659.00     337.22
12  202207   7785.00  217947.00     334.90
13  202206  51926.00  210162.00     334.28
14  202205  28415.00  158236.00     329.20
15  202204   9327.00  129821.00     326.47
16  202203  46565.00  120494.00     325.63
17  202202  12170.00   73929.00     321.12
18  202201  61759.00   61759.00     320.03
19  202112  23580.00  313408.00     314.12
20  202111  25983.00  289828.00     311.90
21  202110  16176.00  263845.00     309.45
22  202109  29026.00  247669.00     308.05
23  202108  29893.00  218643.00     305.29
24  202107  10752.00  188750.00     302.47

```
