# 短期国债利率

**文档ID**: 221
**原始链接**: https://tushare.pro/document/2?doc_id=221

---

## 短期国债利率

接口：us_tbr描述：获取美国短期国债利率数据限量：单次最大可获取2000行数据，可循环获取权限：用户积累120积分可以使用，积分越高频次越高。具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期(YYYYMMDD格式)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>指定输出字段(e.g. fields='w4_bd,w52_ce')</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>w4_bd</td>
<td>float</td>
<td>Y</td>
<td>4周银行折现收益率</td>
</tr>
<tr>
<td>w4_ce</td>
<td>float</td>
<td>Y</td>
<td>4周票面利率</td>
</tr>
<tr>
<td>w8_bd</td>
<td>float</td>
<td>Y</td>
<td>8周银行折现收益率</td>
</tr>
<tr>
<td>w8_ce</td>
<td>float</td>
<td>Y</td>
<td>8周票面利率</td>
</tr>
<tr>
<td>w13_bd</td>
<td>float</td>
<td>Y</td>
<td>13周银行折现收益率</td>
</tr>
<tr>
<td>w13_ce</td>
<td>float</td>
<td>Y</td>
<td>13周票面利率</td>
</tr>
<tr>
<td>w17_bd</td>
<td>float</td>
<td>Y</td>
<td>17周银行折现收益率（数据从20221019开始）</td>
</tr>
<tr>
<td>w17_ce</td>
<td>float</td>
<td>Y</td>
<td>17周票面利率（数据从20221019开始）</td>
</tr>
<tr>
<td>w26_bd</td>
<td>float</td>
<td>Y</td>
<td>26周银行折现收益率</td>
</tr>
<tr>
<td>w26_ce</td>
<td>float</td>
<td>Y</td>
<td>26周票面利率</td>
</tr>
<tr>
<td>w52_bd</td>
<td>float</td>
<td>Y</td>
<td>52周银行折现收益率</td>
</tr>
<tr>
<td>w52_ce</td>
<td>float</td>
<td>Y</td>
<td>52周票面利率</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.us_tbr(start_date='20180101', end_date='20200327')


#获取指定字段数据
df = pro.us_tbr(start_date='20180101', end_date='20200327', fields='w4_bd,w52_ce')

```

数据样例

```
          date  w4_bd  w4_ce  w8_bd  w8_ce w13_bd w13_ce w26_bd w26_ce w52_bd w52_ce
0     20200327   0.01   0.01   0.03   0.03   0.03   0.03   0.02   0.02   0.11   0.11
1     20200326   0.01   0.01   0.01   0.01  -0.05  -0.05   0.04   0.04   0.13   0.13
2     20200325  -0.04  -0.04  -0.03  -0.03  -0.04  -0.04   0.07   0.07   0.19   0.19
3     20200324   0.01   0.01   0.01   0.01   0.01   0.01   0.09   0.09   0.25   0.25
4     20200323   0.01   0.01   0.04   0.04   0.02   0.02   0.08   0.08   0.16   0.16
...        ...    ...    ...    ...    ...    ...    ...    ...    ...    ...    ...
1995  20120405   0.07   0.07   None   None   0.08   0.08   0.14   0.14   0.19   0.19
1996  20120404   0.08   0.08   None   None   0.08   0.08   0.14   0.14   0.19   0.19
1997  20120403   0.07   0.07   None   None   0.08   0.08   0.15   0.15   0.20   0.20
1998  20120402   0.05   0.05   None   None   0.08   0.08   0.14   0.14   0.17   0.17
1999  20120330   0.05   0.05   None   None   0.07   0.07   0.15   0.15   0.18   0.18

```
