# 申万行业指数日行情

**文档ID**: 327
**原始链接**: https://tushare.pro/document/2?doc_id=327

---

## 申万行业日线行情

接口：sw_daily描述：获取申万行业日线行情（默认是申万2021版行情）限量：单次最大4000行数据，可通过指数代码和日期参数循环提取，5000积分可调取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>行业代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>指数名称</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量（万股）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额（万元）</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>Y</td>
<td>市盈率</td>
</tr>
<tr>
<td>pb</td>
<td>float</td>
<td>Y</td>
<td>市净率</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值（万元）</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值（万元）</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api('your token')

#获取20230705当日所有申万行业指数的ts_code,name,open,close,vol,pe,pb数据
df = pro.sw_daily(trade_date='20230705', fields='ts_code,name,open,close,vol,pe,pb')

```

数据示例

```
        ts_code      name      open     close         vol      pe    pb
0    801001.SI      申万50   2972.86   2946.53   275984.00   13.99  1.91
1    801002.SI      申万中小   6963.37   6896.69  1540720.00   21.19  2.47
2    801003.SI      申万Ａ指   3793.91   3769.63  6294567.00   16.56  1.78
3    801005.SI      申万创业   2841.32   2815.48  1220719.00   35.90  3.72
4    801010.SI      农林牧渔   2986.75   2946.60    83532.00   28.32  2.66
..         ...       ...       ...       ...         ...     ...   ...
434  859811.SI      生活用纸   1438.09   1418.16     2542.00   23.25  2.32
435  859821.SI  化妆品制造及其他   2674.85   2674.57     2069.00   40.63  2.33
436  859822.SI     品牌化妆品  12094.45  11877.03     2809.00   44.55  5.52
437  859852.SI      培训教育    780.30    770.10    20889.00  106.12  5.73
438  859951.SI     电视广播Ⅲ   1121.00   1122.06    24413.00   51.46  1.05

```
