# 申万行业成分（分级）

**文档ID**: 335
**原始链接**: https://tushare.pro/document/2?doc_id=335

---

## 申万行业成分构成(分级)

接口：index_member_all描述：按三级分类提取申万行业成分，可提供某个分类的所有成分，也可按股票代码提取所属分类，参数灵活限量：单次最大2000行，总量不限制权限：用户需2000积分可调取，积分获取方法请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>l1_code</td>
<td>str</td>
<td>N</td>
<td>一级行业代码</td>
</tr>
<tr>
<td>l2_code</td>
<td>str</td>
<td>N</td>
<td>二级行业代码</td>
</tr>
<tr>
<td>l3_code</td>
<td>str</td>
<td>N</td>
<td>三级行业代码</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>is_new</td>
<td>str</td>
<td>N</td>
<td>是否最新（默认为“Y是”）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>l1_code</td>
<td>str</td>
<td>Y</td>
<td>一级行业代码</td>
</tr>
<tr>
<td>l1_name</td>
<td>str</td>
<td>Y</td>
<td>一级行业名称</td>
</tr>
<tr>
<td>l2_code</td>
<td>str</td>
<td>Y</td>
<td>二级行业代码</td>
</tr>
<tr>
<td>l2_name</td>
<td>str</td>
<td>Y</td>
<td>二级行业名称</td>
</tr>
<tr>
<td>l3_code</td>
<td>str</td>
<td>Y</td>
<td>三级行业代码</td>
</tr>
<tr>
<td>l3_name</td>
<td>str</td>
<td>Y</td>
<td>三级行业名称</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>成分股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>成分股票名称</td>
</tr>
<tr>
<td>in_date</td>
<td>str</td>
<td>Y</td>
<td>纳入日期</td>
</tr>
<tr>
<td>out_date</td>
<td>str</td>
<td>Y</td>
<td>剔除日期</td>
</tr>
<tr>
<td>is_new</td>
<td>str</td>
<td>Y</td>
<td>是否最新Y是N否</td>
</tr>
</tbody></table>
接口示例

```

#获取黄金分类的成份股
df = pro.index_member_all(l3_code='850531.SI')

#获取000001.SZ所属行业
df = pro.index_member_all(ts_code='000001.SZ')

```

数据示例

```
      l1_code l1_name     l2_code       l2_name  l3_code     l3_name    ts_code       name   in_date
0   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  000506.SZ      *ST中润  20220729
1   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  001337.SZ       四川黄金  20230224
2   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  600988.SH       赤峰黄金  20040414
3   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  600489.SH       中金黄金  20030812
4   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  600547.SH       山东黄金  20030826
5   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  002155.SZ       湖南黄金  20070815
6   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  002237.SZ       恒邦股份  20080428
7   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  601069.SH       西部黄金  20150115
8   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  000975.SZ       银泰黄金  20190724
9   801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  300139.SZ       晓程科技  20220729
10  801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  600687.SH   退市刚泰(退市)  20130701
11  801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  600807.SH       济南高新  20220729
12  801050.SI    有色金属  801053.SI     贵金属  850531.SI      黄金  600311.SH  *ST荣华(退市)  20140102

```
