# 现金流量表

**文档ID**: 44
**原始链接**: https://tushare.pro/document/2?doc_id=44

---

## 现金流量表

接口：cashflow，可以通过数据工具调试和查看数据。描述：获取上市公司现金流量表积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法提示：当前接口只能按单只股票获取其历史数据，如果需要获取某一季度全部上市公司数据，请使用cashflow_vip接口（参数一致），需积攒5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>f_ann_date</td>
<td>str</td>
<td>N</td>
<td>实际公告日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(每个季度最后一天的日期，比如20171231表示年报，20170630半年报，20170930三季报)</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告类型：见下方详细说明</td>
</tr>
<tr>
<td>comp_type</td>
<td>str</td>
<td>N</td>
<td>公司类型：1一般工商业 2银行 3保险 4证券</td>
</tr>
<tr>
<td>is_calc</td>
<td>int</td>
<td>N</td>
<td>是否计算报表</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>f_ann_date</td>
<td>str</td>
<td>Y</td>
<td>实际公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>comp_type</td>
<td>str</td>
<td>Y</td>
<td>公司类型(1一般工商业2银行3保险4证券)</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报表类型</td>
</tr>
<tr>
<td>end_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型</td>
</tr>
<tr>
<td>net_profit</td>
<td>float</td>
<td>Y</td>
<td>净利润</td>
</tr>
<tr>
<td>finan_exp</td>
<td>float</td>
<td>Y</td>
<td>财务费用</td>
</tr>
<tr>
<td>c_fr_sale_sg</td>
<td>float</td>
<td>Y</td>
<td>销售商品、提供劳务收到的现金</td>
</tr>
<tr>
<td>recp_tax_rends</td>
<td>float</td>
<td>Y</td>
<td>收到的税费返还</td>
</tr>
<tr>
<td>n_depos_incr_fi</td>
<td>float</td>
<td>Y</td>
<td>客户存款和同业存放款项净增加额</td>
</tr>
<tr>
<td>n_incr_loans_cb</td>
<td>float</td>
<td>Y</td>
<td>向中央银行借款净增加额</td>
</tr>
<tr>
<td>n_inc_borr_oth_fi</td>
<td>float</td>
<td>Y</td>
<td>向其他金融机构拆入资金净增加额</td>
</tr>
<tr>
<td>prem_fr_orig_contr</td>
<td>float</td>
<td>Y</td>
<td>收到原保险合同保费取得的现金</td>
</tr>
<tr>
<td>n_incr_insured_dep</td>
<td>float</td>
<td>Y</td>
<td>保户储金净增加额</td>
</tr>
<tr>
<td>n_reinsur_prem</td>
<td>float</td>
<td>Y</td>
<td>收到再保业务现金净额</td>
</tr>
<tr>
<td>n_incr_disp_tfa</td>
<td>float</td>
<td>Y</td>
<td>处置交易性金融资产净增加额</td>
</tr>
<tr>
<td>ifc_cash_incr</td>
<td>float</td>
<td>Y</td>
<td>收取利息和手续费净增加额</td>
</tr>
<tr>
<td>n_incr_disp_faas</td>
<td>float</td>
<td>Y</td>
<td>处置可供出售金融资产净增加额</td>
</tr>
<tr>
<td>n_incr_loans_oth_bank</td>
<td>float</td>
<td>Y</td>
<td>拆入资金净增加额</td>
</tr>
<tr>
<td>n_cap_incr_repur</td>
<td>float</td>
<td>Y</td>
<td>回购业务资金净增加额</td>
</tr>
<tr>
<td>c_fr_oth_operate_a</td>
<td>float</td>
<td>Y</td>
<td>收到其他与经营活动有关的现金</td>
</tr>
<tr>
<td>c_inf_fr_operate_a</td>
<td>float</td>
<td>Y</td>
<td>经营活动现金流入小计</td>
</tr>
<tr>
<td>c_paid_goods_s</td>
<td>float</td>
<td>Y</td>
<td>购买商品、接受劳务支付的现金</td>
</tr>
<tr>
<td>c_paid_to_for_empl</td>
<td>float</td>
<td>Y</td>
<td>支付给职工以及为职工支付的现金</td>
</tr>
<tr>
<td>c_paid_for_taxes</td>
<td>float</td>
<td>Y</td>
<td>支付的各项税费</td>
</tr>
<tr>
<td>n_incr_clt_loan_adv</td>
<td>float</td>
<td>Y</td>
<td>客户贷款及垫款净增加额</td>
</tr>
<tr>
<td>n_incr_dep_cbob</td>
<td>float</td>
<td>Y</td>
<td>存放央行和同业款项净增加额</td>
</tr>
<tr>
<td>c_pay_claims_orig_inco</td>
<td>float</td>
<td>Y</td>
<td>支付原保险合同赔付款项的现金</td>
</tr>
<tr>
<td>pay_handling_chrg</td>
<td>float</td>
<td>Y</td>
<td>支付手续费的现金</td>
</tr>
<tr>
<td>pay_comm_insur_plcy</td>
<td>float</td>
<td>Y</td>
<td>支付保单红利的现金</td>
</tr>
<tr>
<td>oth_cash_pay_oper_act</td>
<td>float</td>
<td>Y</td>
<td>支付其他与经营活动有关的现金</td>
</tr>
<tr>
<td>st_cash_out_act</td>
<td>float</td>
<td>Y</td>
<td>经营活动现金流出小计</td>
</tr>
<tr>
<td>n_cashflow_act</td>
<td>float</td>
<td>Y</td>
<td>经营活动产生的现金流量净额</td>
</tr>
<tr>
<td>oth_recp_ral_inv_act</td>
<td>float</td>
<td>Y</td>
<td>收到其他与投资活动有关的现金</td>
</tr>
<tr>
<td>c_disp_withdrwl_invest</td>
<td>float</td>
<td>Y</td>
<td>收回投资收到的现金</td>
</tr>
<tr>
<td>c_recp_return_invest</td>
<td>float</td>
<td>Y</td>
<td>取得投资收益收到的现金</td>
</tr>
<tr>
<td>n_recp_disp_fiolta</td>
<td>float</td>
<td>Y</td>
<td>处置固定资产、无形资产和其他长期资产收回的现金净额</td>
</tr>
<tr>
<td>n_recp_disp_sobu</td>
<td>float</td>
<td>Y</td>
<td>处置子公司及其他营业单位收到的现金净额</td>
</tr>
<tr>
<td>stot_inflows_inv_act</td>
<td>float</td>
<td>Y</td>
<td>投资活动现金流入小计</td>
</tr>
<tr>
<td>c_pay_acq_const_fiolta</td>
<td>float</td>
<td>Y</td>
<td>购建固定资产、无形资产和其他长期资产支付的现金</td>
</tr>
<tr>
<td>c_paid_invest</td>
<td>float</td>
<td>Y</td>
<td>投资支付的现金</td>
</tr>
<tr>
<td>n_disp_subs_oth_biz</td>
<td>float</td>
<td>Y</td>
<td>取得子公司及其他营业单位支付的现金净额</td>
</tr>
<tr>
<td>oth_pay_ral_inv_act</td>
<td>float</td>
<td>Y</td>
<td>支付其他与投资活动有关的现金</td>
</tr>
<tr>
<td>n_incr_pledge_loan</td>
<td>float</td>
<td>Y</td>
<td>质押贷款净增加额</td>
</tr>
<tr>
<td>stot_out_inv_act</td>
<td>float</td>
<td>Y</td>
<td>投资活动现金流出小计</td>
</tr>
<tr>
<td>n_cashflow_inv_act</td>
<td>float</td>
<td>Y</td>
<td>投资活动产生的现金流量净额</td>
</tr>
<tr>
<td>c_recp_borrow</td>
<td>float</td>
<td>Y</td>
<td>取得借款收到的现金</td>
</tr>
<tr>
<td>proc_issue_bonds</td>
<td>float</td>
<td>Y</td>
<td>发行债券收到的现金</td>
</tr>
<tr>
<td>oth_cash_recp_ral_fnc_act</td>
<td>float</td>
<td>Y</td>
<td>收到其他与筹资活动有关的现金</td>
</tr>
<tr>
<td>stot_cash_in_fnc_act</td>
<td>float</td>
<td>Y</td>
<td>筹资活动现金流入小计</td>
</tr>
<tr>
<td>free_cashflow</td>
<td>float</td>
<td>Y</td>
<td>企业自由现金流量</td>
</tr>
<tr>
<td>c_prepay_amt_borr</td>
<td>float</td>
<td>Y</td>
<td>偿还债务支付的现金</td>
</tr>
<tr>
<td>c_pay_dist_dpcp_int_exp</td>
<td>float</td>
<td>Y</td>
<td>分配股利、利润或偿付利息支付的现金</td>
</tr>
<tr>
<td>incl_dvd_profit_paid_sc_ms</td>
<td>float</td>
<td>Y</td>
<td>其中:子公司支付给少数股东的股利、利润</td>
</tr>
<tr>
<td>oth_cashpay_ral_fnc_act</td>
<td>float</td>
<td>Y</td>
<td>支付其他与筹资活动有关的现金</td>
</tr>
<tr>
<td>stot_cashout_fnc_act</td>
<td>float</td>
<td>Y</td>
<td>筹资活动现金流出小计</td>
</tr>
<tr>
<td>n_cash_flows_fnc_act</td>
<td>float</td>
<td>Y</td>
<td>筹资活动产生的现金流量净额</td>
</tr>
<tr>
<td>eff_fx_flu_cash</td>
<td>float</td>
<td>Y</td>
<td>汇率变动对现金的影响</td>
</tr>
<tr>
<td>n_incr_cash_cash_equ</td>
<td>float</td>
<td>Y</td>
<td>现金及现金等价物净增加额</td>
</tr>
<tr>
<td>c_cash_equ_beg_period</td>
<td>float</td>
<td>Y</td>
<td>期初现金及现金等价物余额</td>
</tr>
<tr>
<td>c_cash_equ_end_period</td>
<td>float</td>
<td>Y</td>
<td>期末现金及现金等价物余额</td>
</tr>
<tr>
<td>c_recp_cap_contrib</td>
<td>float</td>
<td>Y</td>
<td>吸收投资收到的现金</td>
</tr>
<tr>
<td>incl_cash_rec_saims</td>
<td>float</td>
<td>Y</td>
<td>其中:子公司吸收少数股东投资收到的现金</td>
</tr>
<tr>
<td>uncon_invest_loss</td>
<td>float</td>
<td>Y</td>
<td>未确认投资损失</td>
</tr>
<tr>
<td>prov_depr_assets</td>
<td>float</td>
<td>Y</td>
<td>加:资产减值准备</td>
</tr>
<tr>
<td>depr_fa_coga_dpba</td>
<td>float</td>
<td>Y</td>
<td>固定资产折旧、油气资产折耗、生产性生物资产折旧</td>
</tr>
<tr>
<td>amort_intang_assets</td>
<td>float</td>
<td>Y</td>
<td>无形资产摊销</td>
</tr>
<tr>
<td>lt_amort_deferred_exp</td>
<td>float</td>
<td>Y</td>
<td>长期待摊费用摊销</td>
</tr>
<tr>
<td>decr_deferred_exp</td>
<td>float</td>
<td>Y</td>
<td>待摊费用减少</td>
</tr>
<tr>
<td>incr_acc_exp</td>
<td>float</td>
<td>Y</td>
<td>预提费用增加</td>
</tr>
<tr>
<td>loss_disp_fiolta</td>
<td>float</td>
<td>Y</td>
<td>处置固定、无形资产和其他长期资产的损失</td>
</tr>
<tr>
<td>loss_scr_fa</td>
<td>float</td>
<td>Y</td>
<td>固定资产报废损失</td>
</tr>
<tr>
<td>loss_fv_chg</td>
<td>float</td>
<td>Y</td>
<td>公允价值变动损失</td>
</tr>
<tr>
<td>invest_loss</td>
<td>float</td>
<td>Y</td>
<td>投资损失</td>
</tr>
<tr>
<td>decr_def_inc_tax_assets</td>
<td>float</td>
<td>Y</td>
<td>递延所得税资产减少</td>
</tr>
<tr>
<td>incr_def_inc_tax_liab</td>
<td>float</td>
<td>Y</td>
<td>递延所得税负债增加</td>
</tr>
<tr>
<td>decr_inventories</td>
<td>float</td>
<td>Y</td>
<td>存货的减少</td>
</tr>
<tr>
<td>decr_oper_payable</td>
<td>float</td>
<td>Y</td>
<td>经营性应收项目的减少</td>
</tr>
<tr>
<td>incr_oper_payable</td>
<td>float</td>
<td>Y</td>
<td>经营性应付项目的增加</td>
</tr>
<tr>
<td>others</td>
<td>float</td>
<td>Y</td>
<td>其他</td>
</tr>
<tr>
<td>im_net_cashflow_oper_act</td>
<td>float</td>
<td>Y</td>
<td>经营活动产生的现金流量净额(间接法)</td>
</tr>
<tr>
<td>conv_debt_into_cap</td>
<td>float</td>
<td>Y</td>
<td>债务转为资本</td>
</tr>
<tr>
<td>conv_copbonds_due_within_1y</td>
<td>float</td>
<td>Y</td>
<td>一年内到期的可转换公司债券</td>
</tr>
<tr>
<td>fa_fnc_leases</td>
<td>float</td>
<td>Y</td>
<td>融资租入固定资产</td>
</tr>
<tr>
<td>im_n_incr_cash_equ</td>
<td>float</td>
<td>Y</td>
<td>现金及现金等价物净增加额(间接法)</td>
</tr>
<tr>
<td>net_dism_capital_add</td>
<td>float</td>
<td>Y</td>
<td>拆出资金净增加额</td>
</tr>
<tr>
<td>net_cash_rece_sec</td>
<td>float</td>
<td>Y</td>
<td>代理买卖证券收到的现金净额(元)</td>
</tr>
<tr>
<td>credit_impa_loss</td>
<td>float</td>
<td>Y</td>
<td>信用减值损失</td>
</tr>
<tr>
<td>use_right_asset_dep</td>
<td>float</td>
<td>Y</td>
<td>使用权资产折旧</td>
</tr>
<tr>
<td>oth_loss_asset</td>
<td>float</td>
<td>Y</td>
<td>其他资产减值损失</td>
</tr>
<tr>
<td>end_bal_cash</td>
<td>float</td>
<td>Y</td>
<td>现金的期末余额</td>
</tr>
<tr>
<td>beg_bal_cash</td>
<td>float</td>
<td>Y</td>
<td>减:现金的期初余额</td>
</tr>
<tr>
<td>end_bal_cash_equ</td>
<td>float</td>
<td>Y</td>
<td>加:现金等价物的期末余额</td>
</tr>
<tr>
<td>beg_bal_cash_equ</td>
<td>float</td>
<td>Y</td>
<td>减:现金等价物的期初余额</td>
</tr>
<tr>
<td>update_flag</td>
<td>str</td>
<td>Y</td>
<td>更新标志(1最新）</td>
</tr>
</tbody></table>
输出参数

接口使用说明

```

pro = ts.pro_api()

df = pro.cashflow(ts_code='600000.SH', start_date='20180101', end_date='20180730')

```

获取某一季度全部股票数据

```
df2 = pro.cashflow_vip(period='20181231',fields='')

```

数据样例

```
     ts_code  ann_date f_ann_date  end_date comp_type report_type    net_profit finan_exp  \
0  600000.SH  20180428   20180428  20180331         2           1           NaN      None   
1  600000.SH  20180428   20180428  20171231         2           1  5.500200e+10      None   
2  600000.SH  20180428   20180428  20171231         2           1  5.500200e+10      None
    
    

```

主要报表类型说明

<table>
<thead>
<tr>
<th>代码</th>
<th>类型</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1</td>
<td>合并报表</td>
<td>上市公司最新报表（默认）</td>
</tr>
<tr>
<td>2</td>
<td>单季合并</td>
<td>单一季度的合并报表</td>
</tr>
<tr>
<td>3</td>
<td>调整单季合并表</td>
<td>调整后的单季合并报表（如果有）</td>
</tr>
<tr>
<td>4</td>
<td>调整合并报表</td>
<td>本年度公布上年同期的财务报表数据，报告期为上年度</td>
</tr>
<tr>
<td>5</td>
<td>调整前合并报表</td>
<td>数据发生变更，将原数据进行保留，即调整前的原数据</td>
</tr>
<tr>
<td>6</td>
<td>母公司报表</td>
<td>该公司母公司的财务报表数据</td>
</tr>
<tr>
<td>7</td>
<td>母公司单季表</td>
<td>母公司的单季度表</td>
</tr>
<tr>
<td>8</td>
<td>母公司调整单季表</td>
<td>母公司调整后的单季表</td>
</tr>
<tr>
<td>9</td>
<td>母公司调整表</td>
<td>该公司母公司的本年度公布上年同期的财务报表数据</td>
</tr>
<tr>
<td>10</td>
<td>母公司调整前报表</td>
<td>母公司调整之前的原始财务报表数据</td>
</tr>
<tr>
<td>11</td>
<td>目公司调整前合并报表</td>
<td>母公司调整之前合并报表原数据</td>
</tr>
<tr>
<td>12</td>
<td>母公司调整前报表</td>
<td>母公司报表发生变更前保留的原数据</td>
</tr>
</tbody></table>