# 港股通每日成交统计

**文档ID**: 196
**原始链接**: https://tushare.pro/document/2?doc_id=196

---

## 港股通每日成交统计

接口：ggt_daily描述：获取港股通每日成交信息，数据从2014年开始限量：单次最大1000，总量数据不限制积分：用户积2000积分可调取，5000积分以上频次相对较高，请自行提高积分，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （格式YYYYMMDD，下同。支持单日和多日输入）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>buy_amount</td>
<td>float</td>
<td>Y</td>
<td>买入成交金额（亿元）</td>
</tr>
<tr>
<td>buy_volume</td>
<td>float</td>
<td>Y</td>
<td>买入成交笔数（万笔）</td>
</tr>
<tr>
<td>sell_amount</td>
<td>float</td>
<td>Y</td>
<td>卖出成交金额（亿元）</td>
</tr>
<tr>
<td>sell_volume</td>
<td>float</td>
<td>Y</td>
<td>卖出成交笔数（万笔）</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取单日全部统计
df = pro.ggt_daily(trade_date='20190625')

#获取多日统计信息
df = pro.ggt_daily(trade_date='20190925,20180924,20170925')

#获取时间段统计信息
df = pro.ggt_daily(start_date='20180925', end_date='20190925)
```

数据示例

```
    trade_date  buy_amount  buy_volume  sell_amount  sell_volume
0     20190925       31.22        5.54        27.07         4.55
1     20190924       37.69        5.53        39.14         6.13
2     20190923       26.69        4.43        31.50         5.01
3     20190920       35.62        6.16        33.41         5.49
4     20190919       31.80        5.83        29.34         5.24
5     20190918       26.58        5.27        28.93         6.14
6     20190917       29.92        5.76        32.70         6.30
7     20190916       44.19        7.78        50.91         8.97
8     20190910       30.79        6.04        32.89         5.99
9     20190909       35.48        7.01        34.05         6.44
10    20190906       39.46        6.98        29.47         6.07
11    20190905       57.00       10.46        37.84         7.31
12    20190904       49.68        8.43        43.17         6.17
13    20190903       33.44        6.46        23.18         4.73
14    20190902       43.02        6.91        28.06         5.64
15    20190830       35.94        6.51        26.58         6.10
16    20190829       39.11        6.89        24.95         4.60
17    20190828       39.04        7.46        27.54         5.09
18    20190827       44.36        9.44        23.12         4.84
19    20190826       55.89        9.23        22.58         4.40
20    20190823       33.91        6.28        18.83         4.66
21    20190822       38.21        7.38        19.00         4.38
22    20190821       35.38        6.42        20.39         3.77
```
