# 港股通十大成交股

**文档ID**: 49
**原始链接**: https://tushare.pro/document/2?doc_id=49

---

## 港股通十大成交股

接口：ggt_top10描述：获取港股通每日成交数据，其中包括沪市、深市详细数据，每天18~20点之间完成当日更新

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码（二选一）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（二选一）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>market_type</td>
<td>str</td>
<td>N</td>
<td>市场类型 2：港股通（沪） 4：港股通（深）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>股票名称</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>收盘价</td>
</tr>
<tr>
<td>p_change</td>
<td>float</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>rank</td>
<td>str</td>
<td>资金排名</td>
</tr>
<tr>
<td>market_type</td>
<td>str</td>
<td>市场类型 2：港股通（沪） 4：港股通（深）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>累计成交金额（元）</td>
</tr>
<tr>
<td>net_amount</td>
<td>float</td>
<td>净买入金额（元）</td>
</tr>
<tr>
<td>sh_amount</td>
<td>float</td>
<td>沪市成交金额（元）</td>
</tr>
<tr>
<td>sh_net_amount</td>
<td>float</td>
<td>沪市净买入金额（元）</td>
</tr>
<tr>
<td>sh_buy</td>
<td>float</td>
<td>沪市买入金额（元）</td>
</tr>
<tr>
<td>sh_sell</td>
<td>float</td>
<td>沪市卖出金额</td>
</tr>
<tr>
<td>sz_amount</td>
<td>float</td>
<td>深市成交金额（元）</td>
</tr>
<tr>
<td>sz_net_amount</td>
<td>float</td>
<td>深市净买入金额（元）</td>
</tr>
<tr>
<td>sz_buy</td>
<td>float</td>
<td>深市买入金额（元）</td>
</tr>
<tr>
<td>sz_sell</td>
<td>float</td>
<td>深市卖出金额（元）</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

pro.ggt_top10(trade_date='20180727')

```

或者

```

pro.query('ggt_top10', ts_code='00700', start_date='20180701', end_date='20180727')

```

数据样例

```
   trade_date ts_code       name   close   p_change  rank   market_type  \
0    20180727   00175    吉利汽车   18.42   -3.2563   4.0            2   
1    20180727   00175    吉利汽车   18.42   -3.2563   4.0            4   
2    20180727   00581  中国东方集团    6.60    5.9390   NaN          4   
3    20180727   00607    丰盛控股    3.48   -2.5210   NaN            4   
4    20180727   00700    腾讯控股  373.00   -0.4803   1.0            2   
5    20180727   00700    腾讯控股  373.00   -0.4803   1.0            4   
6    20180727   00763    中兴通讯   13.74    0.8811   NaN            4   
7    20180727   00914    海螺水泥   49.10    2.1852   NaN            4   
8    20180727   00939    建设银行    7.11   -0.5594   2.0            2   
9    20180727   01088    中国神华   18.24    3.2843   9.0            2   
10   20180727   01288    农业银行    3.81    0.0000   5.0            2   
11   20180727   01299    友邦保险   68.65    0.5124   6.0            2   
12   20180727   01317    枫叶教育    7.07    1.1445   NaN            4   
13   20180727   01398    工商银行    5.82    0.0000   3.0            2   
14   20180727   01448     福寿园    7.60   -4.6424   NaN             4   
15   20180727   01918    融创中国   25.25   -0.3945  10.0            2   
16   20180727   02208    金风科技   10.30    4.9949   NaN            4   
17   20180727   02382  舜宇光学科技  138.60    0.8734   8.0          2   
18   20180727   02382  舜宇光学科技  138.60    0.8734   8.0          4   
19   20180727   03988    中国银行    3.69    0.0000   7.0            2 

         amount   net_amount    sh_amount  sh_net_amount       sh_buy  \
0   476991220.0  -71294840.0  182183940.0    -30957820.0   75613060.0   
1   294807280.0  -71294840.0  182183940.0    -30957820.0   75613060.0   
2    49196800.0   23544640.0          NaN            NaN          NaN   
3    44903050.0  -36431000.0          NaN            NaN          NaN   
4   519061900.0 -219372420.0  383183900.0   -189541460.0   96821220.0   
5   654939900.0 -219372420.0  383183900.0   -189541460.0   96821220.0   
6    94728576.0    5410088.0          NaN            NaN          NaN   
7    97702200.0   97505000.0          NaN            NaN          NaN   
8   379189670.0 -294782730.0  379189670.0   -294782730.0   42203470.0   
9    75536270.0   30045150.0   75536270.0     30045150.0   52790710.0   
10  143294570.0   19808330.0  143294570.0     19808330.0   81551450.0   
11  114038360.0 -112839500.0  114038360.0   -112839500.0     599430.0   
12   50733740.0   13866820.0          NaN            NaN          NaN   
13  237510790.0  162518450.0  237510790.0    162518450.0  200014620.0   
14   54901320.0   24257620.0          NaN            NaN          NaN   
15   75175350.0   -4871850.0   75175350.0     -4871850.0   35151750.0   
16   83730480.0     775296.0          NaN            NaN          NaN   
17  272358740.0  130884350.0  108526330.0     85936290.0   97231310.0   
18  163832410.0  130884350.0  108526330.0     85936290.0   97231310.0   
19  108853650.0 -106781530.0  108853650.0   -106781530.0    1036060.0   

        sh_sell    sz_amount  sh_net_amount      sz_buy     sz_sell  
0   106570880.0  112623340.0    -40337020.0  36143160.0  76480180.0  
1   106570880.0  112623340.0    -40337020.0  36143160.0  76480180.0  
2           NaN   49196800.0     23544640.0  36370720.0  12826080.0  
3           NaN   44903050.0    -36431000.0   4236025.0  40667025.0  
4   286362680.0  135878000.0    -29830960.0  53023520.0  82854480.0  
5   286362680.0  135878000.0    -29830960.0  53023520.0  82854480.0  
6           NaN   94728576.0      5410088.0  50069332.0  44659244.0  
7           NaN   97702200.0     97505000.0  97603600.0     98600.0  
8   336986200.0          NaN            NaN         NaN         NaN  
9    22745560.0          NaN            NaN         NaN         NaN  
10   61743120.0          NaN            NaN         NaN         NaN  
11  113438930.0          NaN            NaN         NaN         NaN  
12          NaN   50733740.0     13866820.0  32300280.0  18433460.0  
13   37496170.0          NaN            NaN         NaN         NaN  
14          NaN   54901320.0     24257620.0  39579470.0  15321850.0  
15   40023600.0          NaN            NaN         NaN         NaN  
16          NaN   83730480.0       775296.0  42252888.0  41477592.0  
17   11295020.0   55306080.0     44948060.0  50127070.0   5179010.0  
18   11295020.0   55306080.0     44948060.0  50127070.0   5179010.0  
19  107817590.0          NaN            NaN         NaN         NaN

```
