# 港股资产负债表

**文档ID**: 390
**原始链接**: https://tushare.pro/document/2?doc_id=390

---

## 港股资产负债表

接口：hk_balancesheet，可以通过数据工具调试和查看数据。描述：获取港股上市公司资产负债表权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(格式：YYYYMMDD）</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>N</td>
<td>指标名（如：应收帐款）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束始日期（格式：YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>Y</td>
<td>财务科目名称</td>
</tr>
<tr>
<td>ind_value</td>
<td>float</td>
<td>Y</td>
<td>财务科目值</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取港股腾讯控股00700.HK股票2014年度的资产负债表数据
df = pro.hk_balancesheet(ts_code='00700.HK', period='20241231')

#获取港股腾讯控股00700.HK股票历年应收帐款指标数据
df = pro.hk_balancesheet(ts_code='00700.HK', ind_name='应收帐款')

```

数据样例

```
     ts_code  name      end_date               ind_name     ind_value
0   00700.HK  腾讯控股  20241231             物业厂房及设备  8.018500e+10
1   00700.HK  腾讯控股  20241231             非流动负债合计  3.301900e+11
2   00700.HK  腾讯控股  20241231                无形资产  1.961270e+11
3   00700.HK  腾讯控股  20241231               土地使用权  2.311700e+10
4   00700.HK  腾讯控股  20241231                在建工程  1.230200e+10
5   00700.HK  腾讯控股  20241231              递延税项资产  2.832500e+10
6   00700.HK  腾讯控股  20241231                预付款项  4.282800e+10
7   00700.HK  腾讯控股  20241231              联营公司权益  2.903430e+11
8   00700.HK  腾讯控股  20241231              合营公司权益  7.072000e+09
9   00700.HK  腾讯控股  20241231      指定以公允价值记账之金融资产  5.073590e+11
10  00700.HK  腾讯控股  20241231               中长期存款  7.760100e+10
11  00700.HK  腾讯控股  20241231         其他金融资产(非流动)  1.076000e+09
12  00700.HK  腾讯控股  20241231           非流动资产其他项目  1.767900e+10
13  00700.HK  腾讯控股  20241231             非流动资产合计  1.284815e+12
14  00700.HK  腾讯控股  20241231                投资物业  8.010000e+08
15  00700.HK  腾讯控股  20241231                应收帐款  4.820300e+10
16  00700.HK  腾讯控股  20241231         预付款按金及其他应收款  1.010440e+11
17  00700.HK  腾讯控股  20241231            受限制存款及现金  3.334000e+09
18  00700.HK  腾讯控股  20241231              现金及等价物  1.325190e+11
19  00700.HK  腾讯控股  20241231                短期存款  1.929770e+11
20  00700.HK  腾讯控股  20241231  指定以公允价值记账之金融资产(流动)  1.291300e+10
21  00700.HK  腾讯控股  20241231          其他金融资产(流动)  4.750000e+09
22  00700.HK  腾讯控股  20241231              流动资产合计  4.961800e+11
23  00700.HK  腾讯控股  20241231                 总资产  1.780995e+12
24  00700.HK  腾讯控股  20241231                应付帐款  1.187120e+11
25  00700.HK  腾讯控股  20241231                应付票据  8.623000e+09
26  00700.HK  腾讯控股  20241231                应付税项  2.062400e+10
27  00700.HK  腾讯控股  20241231          融资租赁负债(流动)  5.600000e+09
28  00700.HK  腾讯控股  20241231            递延收入(流动)  1.000970e+11
29  00700.HK  腾讯控股  20241231          其他应付款及应计费用  8.403200e+10
30  00700.HK  腾讯控股  20241231                短期贷款  5.288500e+10
31  00700.HK  腾讯控股  20241231          其他金融负债(流动)  6.336000e+09
32  00700.HK  腾讯控股  20241231              流动负债合计  3.969090e+11
33  00700.HK  腾讯控股  20241231               净流动资产  9.927100e+10
34  00700.HK  腾讯控股  20241231            总资产减流动负债  1.384086e+12
35  00700.HK  腾讯控股  20241231                长期贷款  1.465210e+11
36  00700.HK  腾讯控股  20241231              递延税项负债  1.854600e+10
37  00700.HK  腾讯控股  20241231         融资租赁负债(非流动)  1.389700e+10
38  00700.HK  腾讯控股  20241231           递延收入(非流动)  6.236000e+09
39  00700.HK  腾讯控股  20241231               长期应付款  1.020100e+10
40  00700.HK  腾讯控股  20241231           应付票据(非流动)  1.305860e+11
41  00700.HK  腾讯控股  20241231         其他金融负债(非流动)  4.203000e+09
42  00700.HK  腾讯控股  20241231             总权益及总负债  1.780995e+12
43  00700.HK  腾讯控股  20241231                 总负债  7.270990e+11
44  00700.HK  腾讯控股  20241231              少数股东权益  8.034800e+10
45  00700.HK  腾讯控股  20241231                 净资产  1.053896e+12
46  00700.HK  腾讯控股  20241231                  股本           NaN
47  00700.HK  腾讯控股  20241231                股本溢价  4.307900e+10
48  00700.HK  腾讯控股  20241231          保留溢利(累计亏损)  8.920300e+11
49  00700.HK  腾讯控股  20241231                其他储备  4.203600e+10
50  00700.HK  腾讯控股  20241231                 库存股 -3.597000e+09
51  00700.HK  腾讯控股  20241231                股东权益  9.735480e+11
52  00700.HK  腾讯控股  20241231                 总权益  1.053896e+12
53  00700.HK  腾讯控股  20241231           总权益及非流动负债  1.384086e+12
54  00700.HK  腾讯控股  20241231                  存货  4.400000e+08

```
