# 港股财务指标数据

**文档ID**: 388
**原始链接**: https://tushare.pro/document/2?doc_id=388

---

## 港股财务指标数据

接口：hk_fina_indicator，可以通过数据工具调试和查看数据。描述：获取港股上市公司财务指标数据，为避免服务器压力，现阶段每次请求最多返回200条记录，可通过设置日期多次请求获取更多数据。权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(格式：YYYYMMDD）</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>N</td>
<td>报告期类型（Q1一季报Q2半年报Q3三季报Q4年报）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期(格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束日期(格式：YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>ind_type</td>
<td>str</td>
<td>Y</td>
<td>报告类型,Q-按报告期(季度),Y-按年度</td>
</tr>
<tr>
<td>report_type</td>
<td>str</td>
<td>Y</td>
<td>报告期类型</td>
</tr>
<tr>
<td>std_report_date</td>
<td>str</td>
<td>Y</td>
<td>标准报告期</td>
</tr>
<tr>
<td>per_netcash_operate</td>
<td>float</td>
<td>Y</td>
<td>每股经营现金流(元)</td>
</tr>
<tr>
<td>per_oi</td>
<td>float</td>
<td>Y</td>
<td>每股营业收入(元)</td>
</tr>
<tr>
<td>bps</td>
<td>float</td>
<td>Y</td>
<td>每股净资产(元)</td>
</tr>
<tr>
<td>basic_eps</td>
<td>float</td>
<td>Y</td>
<td>基本每股收益(元)</td>
</tr>
<tr>
<td>diluted_eps</td>
<td>float</td>
<td>Y</td>
<td>稀释每股收益(元)</td>
</tr>
<tr>
<td>operate_income</td>
<td>float</td>
<td>Y</td>
<td>营业总收入(元)</td>
</tr>
<tr>
<td>operate_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>营业总收入同比增长(%)</td>
</tr>
<tr>
<td>gross_profit</td>
<td>float</td>
<td>Y</td>
<td>毛利润(元)</td>
</tr>
<tr>
<td>gross_profit_yoy</td>
<td>float</td>
<td>Y</td>
<td>毛利润同比增长(%)</td>
</tr>
<tr>
<td>holder_profit</td>
<td>float</td>
<td>Y</td>
<td>归母净利润(元)</td>
</tr>
<tr>
<td>holder_profit_yoy</td>
<td>float</td>
<td>Y</td>
<td>归母净利润同比增长(%)</td>
</tr>
<tr>
<td>gross_profit_ratio</td>
<td>float</td>
<td>Y</td>
<td>毛利率(%)</td>
</tr>
<tr>
<td>eps_ttm</td>
<td>float</td>
<td>Y</td>
<td>ttm每股收益(元)</td>
</tr>
<tr>
<td>operate_income_qoq</td>
<td>float</td>
<td>Y</td>
<td>营业总收入滚动环比增长(%)</td>
</tr>
<tr>
<td>net_profit_ratio</td>
<td>float</td>
<td>Y</td>
<td>净利率(%)</td>
</tr>
<tr>
<td>roe_avg</td>
<td>float</td>
<td>Y</td>
<td>平均净资产收益率(%)</td>
</tr>
<tr>
<td>gross_profit_qoq</td>
<td>float</td>
<td>Y</td>
<td>毛利润滚动环比增长(%)</td>
</tr>
<tr>
<td>roa</td>
<td>float</td>
<td>Y</td>
<td>总资产净利率(%)</td>
</tr>
<tr>
<td>holder_profit_qoq</td>
<td>float</td>
<td>Y</td>
<td>归母净利润滚动环比增长(%)</td>
</tr>
<tr>
<td>roe_yearly</td>
<td>float</td>
<td>Y</td>
<td>年化净资产收益率(%)</td>
</tr>
<tr>
<td>roic_yearly</td>
<td>float</td>
<td>Y</td>
<td>年化投资回报率(%)</td>
</tr>
<tr>
<td>total_assets</td>
<td>float</td>
<td>Y</td>
<td>资产总额</td>
</tr>
<tr>
<td>total_liabilities</td>
<td>float</td>
<td>Y</td>
<td>负债总额</td>
</tr>
<tr>
<td>tax_ebt</td>
<td>float</td>
<td>Y</td>
<td>所得税/利润总额(%)</td>
</tr>
<tr>
<td>ocf_sales</td>
<td>float</td>
<td>Y</td>
<td>经营现金流/营业收入(%)</td>
</tr>
<tr>
<td>total_parent_equity</td>
<td>float</td>
<td>Y</td>
<td>本公司权益持有人应占权益</td>
</tr>
<tr>
<td>debt_asset_ratio</td>
<td>float</td>
<td>Y</td>
<td>资产负债率(%)</td>
</tr>
<tr>
<td>operate_profit</td>
<td>float</td>
<td>Y</td>
<td>经营盈利</td>
</tr>
<tr>
<td>pretax_profit</td>
<td>float</td>
<td>Y</td>
<td>除税前盈利</td>
</tr>
<tr>
<td>netcash_operate</td>
<td>float</td>
<td>Y</td>
<td>经营活动所得现金流量净额</td>
</tr>
<tr>
<td>netcash_invest</td>
<td>float</td>
<td>Y</td>
<td>投资活动耗用现金流量净额</td>
</tr>
<tr>
<td>netcash_finance</td>
<td>float</td>
<td>Y</td>
<td>融资活动耗用现金流量净额</td>
</tr>
<tr>
<td>end_cash</td>
<td>float</td>
<td>Y</td>
<td>期末的现金及现金等价物</td>
</tr>
<tr>
<td>divi_ratio</td>
<td>float</td>
<td>Y</td>
<td>分红比例</td>
</tr>
<tr>
<td>dividend_rate</td>
<td>float</td>
<td>Y</td>
<td>股息率</td>
</tr>
<tr>
<td>current_ratio</td>
<td>float</td>
<td>Y</td>
<td>流动比率(倍)</td>
</tr>
<tr>
<td>common_acs</td>
<td>float</td>
<td>Y</td>
<td>普通股应计股息</td>
</tr>
<tr>
<td>currentdebt_debt</td>
<td>float</td>
<td>Y</td>
<td>流动负债/总负债(%)</td>
</tr>
<tr>
<td>issued_common_shares</td>
<td>float</td>
<td>Y</td>
<td>已发行普通股</td>
</tr>
<tr>
<td>hk_common_shares</td>
<td>float</td>
<td>Y</td>
<td>港股本</td>
</tr>
<tr>
<td>per_shares</td>
<td>float</td>
<td>Y</td>
<td>每手股数</td>
</tr>
<tr>
<td>total_market_cap</td>
<td>float</td>
<td>Y</td>
<td>总市值</td>
</tr>
<tr>
<td>hksk_market_cap</td>
<td>float</td>
<td>Y</td>
<td>港股市值</td>
</tr>
<tr>
<td>pe_ttm</td>
<td>float</td>
<td>Y</td>
<td>滚动市盈率</td>
</tr>
<tr>
<td>pb_ttm</td>
<td>float</td>
<td>Y</td>
<td>滚动市净率</td>
</tr>
<tr>
<td>report_date_sq</td>
<td>str</td>
<td>Y</td>
<td>季报日期</td>
</tr>
<tr>
<td>report_type_sq</td>
<td>str</td>
<td>Y</td>
<td>报告类型</td>
</tr>
<tr>
<td>operate_income_sq</td>
<td>float</td>
<td>Y</td>
<td>营业收入</td>
</tr>
<tr>
<td>dps_hkd</td>
<td>float</td>
<td>Y</td>
<td>每股股息（港元）</td>
</tr>
<tr>
<td>operate_income_qoq_sq</td>
<td>float</td>
<td>Y</td>
<td>营业收入环比</td>
</tr>
<tr>
<td>net_profit_ratio_sq</td>
<td>float</td>
<td>Y</td>
<td>净利润率</td>
</tr>
<tr>
<td>holder_profit_sq</td>
<td>float</td>
<td>Y</td>
<td>归属于股东净利润</td>
</tr>
<tr>
<td>holder_profit_qoq_sq</td>
<td>float</td>
<td>Y</td>
<td>归母净利润环比</td>
</tr>
<tr>
<td>roe_avg_sq</td>
<td>float</td>
<td>Y</td>
<td>平均净资产收益率</td>
</tr>
<tr>
<td>pe_ttm_sq</td>
<td>float</td>
<td>Y</td>
<td>季报滚动市盈率</td>
</tr>
<tr>
<td>pb_ttm_sq</td>
<td>float</td>
<td>Y</td>
<td>季报滚动市净率</td>
</tr>
<tr>
<td>roa_sq</td>
<td>float</td>
<td>Y</td>
<td>总资产收益率</td>
</tr>
<tr>
<td>start_date</td>
<td>float</td>
<td>Y</td>
<td>会计年度起始日</td>
</tr>
<tr>
<td>fiscal_year</td>
<td>float</td>
<td>Y</td>
<td>会计年度截止日</td>
</tr>
<tr>
<td>currency</td>
<td>str</td>
<td>Y</td>
<td>币种 港元（hkd）</td>
</tr>
<tr>
<td>is_cny_code</td>
<td>float</td>
<td>Y</td>
<td>是否人民币代码</td>
</tr>
<tr>
<td>dps_hkd_ly</td>
<td>float</td>
<td>Y</td>
<td>上一年每股股息</td>
</tr>
<tr>
<td>org_type</td>
<td>str</td>
<td>Y</td>
<td>企业类型</td>
</tr>
<tr>
<td>premium_income</td>
<td>float</td>
<td>Y</td>
<td>保费收入</td>
</tr>
<tr>
<td>premium_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>保费收入同比</td>
</tr>
<tr>
<td>net_interest_income</td>
<td>float</td>
<td>Y</td>
<td>净利息收入</td>
</tr>
<tr>
<td>net_interest_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>净利息收入同比</td>
</tr>
<tr>
<td>fee_commission_income</td>
<td>float</td>
<td>Y</td>
<td>手续费及佣金收入</td>
</tr>
<tr>
<td>fee_commission_income_yoy</td>
<td>float</td>
<td>Y</td>
<td>手续费及佣金收入同比</td>
</tr>
<tr>
<td>accounts_rece_tdays</td>
<td>float</td>
<td>Y</td>
<td>应收账款周转率(次)</td>
</tr>
<tr>
<td>inventory_tdays</td>
<td>float</td>
<td>Y</td>
<td>存货周转率(次)</td>
</tr>
<tr>
<td>current_assets_tdays</td>
<td>float</td>
<td>Y</td>
<td>流动资产周转率(次)</td>
</tr>
<tr>
<td>total_assets_tdays</td>
<td>float</td>
<td>Y</td>
<td>总资产周转率(次)</td>
</tr>
<tr>
<td>premium_expense</td>
<td>float</td>
<td>Y</td>
<td>保险赔付支出</td>
</tr>
<tr>
<td>loan_deposit</td>
<td>float</td>
<td>Y</td>
<td>贷款/存款</td>
</tr>
<tr>
<td>loan_equity</td>
<td>float</td>
<td>Y</td>
<td>贷款/股东权益</td>
</tr>
<tr>
<td>loan_assets</td>
<td>float</td>
<td>Y</td>
<td>贷款/总资产</td>
</tr>
<tr>
<td>deposit_equity</td>
<td>float</td>
<td>Y</td>
<td>存款/股东权益</td>
</tr>
<tr>
<td>deposit_assets</td>
<td>float</td>
<td>Y</td>
<td>存款/总资产</td>
</tr>
<tr>
<td>equity_multiplier</td>
<td>float</td>
<td>Y</td>
<td>权益乘数</td>
</tr>
<tr>
<td>equity_ratio</td>
<td>float</td>
<td>Y</td>
<td>产权比率</td>
</tr>
</tbody></table>
注：输出指标太多可在接口fields参数设定你需要的指标，例如：fields='ts_coe,bps,basic_eps'

接口用法

```

pro = ts.pro_api()

#获取港股腾讯控股00700.HK股票2014年度的财务指标数据
df = pro.hk_fina_indicator(ts_code='00700.HK', period='20241231')

#获取港股腾讯控股00700.HK股票历年年报财务指标数据
df = pro.hk_fina_indicator(ts_code='00700.HK', report_type='Q4')

```

数据样例

```
         ts_code  name  end_date  ... deposit_assets equity_multiplier equity_ratio
0   00700.HK  腾讯控股  20250331  ...           None            1.7083       0.7644
1   00700.HK  腾讯控股  20241231  ...           None            1.6899       0.7469
2   00700.HK  腾讯控股  20240930  ...           None            1.7576       0.8140
3   00700.HK  腾讯控股  20240630  ...           None            1.7841       0.8451
4   00700.HK  腾讯控股  20240331  ...           None            1.7962       0.8601
..       ...   ...       ...  ...            ...               ...          ...
86  00700.HK  腾讯控股  20030930  ...           None               NaN          NaN
87  00700.HK  腾讯控股  20030630  ...           None               NaN          NaN
88  00700.HK  腾讯控股  20030331  ...           None               NaN          NaN
89  00700.HK  腾讯控股  20021231  ...           None            1.0794       0.0794
90  00700.HK  腾讯控股  20011231  ...           None            1.3563       0.3563

```
