# 港股现金流量表

**文档ID**: 391
**原始链接**: https://tushare.pro/document/2?doc_id=391

---

## 港股现金流量表

接口：hk_cashflow，可以通过数据工具调试和查看数据。描述：获取港股上市公司现金流量表数据权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(格式：YYYYMMDD）</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>N</td>
<td>指标名（如：新增贷款）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束始日期（格式：YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>Y</td>
<td>财务科目名称</td>
</tr>
<tr>
<td>ind_value</td>
<td>float</td>
<td>Y</td>
<td>财务科目值</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()


#获取腾讯控股00700.HK股票的2024年度资产负债表数据
df = pro.hk_cashflow(ts_code='00700.HK', period='20241231')

#获取腾讯控股00700.HK股票资产负债表历年新增借款数据
df = pro.hk_cashflow(ts_code='00700.HK', ind_name='新增借款')

```

数据样例

```
     ts_code  end_date  name                       ind_name     ind_value
0   00700.HK  20241231  腾讯控股           除税前溢利(业务利润)  2.414850e+11
1   00700.HK  20241231  腾讯控股                  发行股份  2.093000e+09
2   00700.HK  20241231  腾讯控股                加:利息支出  1.244700e+10
3   00700.HK  20241231  腾讯控股                减:投资收益  7.150000e+08
4   00700.HK  20241231  腾讯控股            减:应占附属公司溢利  2.517600e+10
5   00700.HK  20241231  腾讯控股               加:减值及拨备  9.983000e+09
6   00700.HK  20241231  腾讯控股                减:重估盈余  2.641000e+09
7   00700.HK  20241231  腾讯控股             减:出售资产之溢利  1.300400e+10
8   00700.HK  20241231  腾讯控股               加:折旧及摊销  5.621300e+10
9   00700.HK  20241231  腾讯控股                减:汇兑收益  4.660000e+08
10  00700.HK  20241231  腾讯控股            加:经营调整其他项目  2.070200e+10
11  00700.HK  20241231  腾讯控股           营运资金变动前经营溢利  2.828240e+11
12  00700.HK  20241231  腾讯控股              存货(增加)减少  2.000000e+07
13  00700.HK  20241231  腾讯控股                减:利息收入  1.600400e+10
14  00700.HK  20241231  腾讯控股       应付帐款及应计费用增加(减少)  1.087200e+10
15  00700.HK  20241231  腾讯控股            营运资本变动其他项目 -3.630000e+08
16  00700.HK  20241231  腾讯控股  预付款项、按金及其他应收款项减少(增加)  2.632000e+09
17  00700.HK  20241231  腾讯控股   预收账款、按金及其他应付款增加(减少) -6.765000e+09
18  00700.HK  20241231  腾讯控股            递延收入(增加)减少  1.653300e+10
19  00700.HK  20241231  腾讯控股                经营产生现金  3.047050e+11
20  00700.HK  20241231  腾讯控股                  已付税项  4.618400e+10
21  00700.HK  20241231  腾讯控股              经营业务现金净额  2.585210e+11
22  00700.HK  20241231  腾讯控股              已收利息(投资)  1.491300e+10
23  00700.HK  20241231  腾讯控股              已收股息(投资)  3.521000e+09
24  00700.HK  20241231  腾讯控股              存款减少(增加) -5.227700e+10
25  00700.HK  20241231  腾讯控股                处置固定资产  2.030000e+08
26  00700.HK  20241231  腾讯控股           购建无形资产及其他资产  3.312100e+10
27  00700.HK  20241231  腾讯控股                出售附属公司  4.895000e+09
28  00700.HK  20241231  腾讯控股                收购附属公司  9.836000e+09
29  00700.HK  20241231  腾讯控股              收回投资所得现金  9.505200e+10
30  00700.HK  20241231  腾讯控股                投资支付现金  8.246500e+10
31  00700.HK  20241231  腾讯控股              投资业务其他项目 -6.307200e+10
32  00700.HK  20241231  腾讯控股              投资业务现金净额 -1.221870e+11
33  00700.HK  20241231  腾讯控股               融资前现金净额  1.363340e+11
34  00700.HK  20241231  腾讯控股                  新增借款  1.145840e+11
35  00700.HK  20241231  腾讯控股                  偿还借款  1.146910e+11
36  00700.HK  20241231  腾讯控股              已付利息(融资)  1.241700e+10
37  00700.HK  20241231  腾讯控股              已付股息(融资)  3.124400e+10
38  00700.HK  20241231  腾讯控股                 非运算项目  2.414850e+11
39  00700.HK  20241231  腾讯控股                  回购股份  1.057510e+11
40  00700.HK  20241231  腾讯控股                  赎回债券  1.421300e+10
41  00700.HK  20241231  腾讯控股                偿还融资租赁  6.369000e+09
42  00700.HK  20241231  腾讯控股       购买子公司少数股权而支付的现金  8.381000e+09
43  00700.HK  20241231  腾讯控股              融资业务其他项目 -1.050000e+08
44  00700.HK  20241231  腾讯控股              融资业务现金净额 -1.764940e+11
45  00700.HK  20241231  腾讯控股                  现金净额 -4.016000e+10
46  00700.HK  20241231  腾讯控股                  期初现金  1.723200e+11
47  00700.HK  20241231  腾讯控股              期间变动其他项目  3.590000e+08
48  00700.HK  20241231  腾讯控股                  期末现金  1.325190e+11
49  00700.HK  20241231  腾讯控股                应收帐款减少 -1.048000e+09

```
