# 港股日线行情

**文档ID**: 192
**原始链接**: https://tushare.pro/document/2?doc_id=192

---

## 港股行情

接口：hk_daily，可以通过数据工具调试和查看数据。描述：获取港股每日增量和历史行情，每日18点左右更新当日数据限量：单次最大提取5000行记录，可多次提取，总量不限制积分：本接口单独开权限，具体请参阅权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅(%)</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量(股)</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额(元)</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取单一股票行情
df = pro.hk_daily(ts_code='00001.HK', start_date='20190101', end_date='20190904')

#获取某一日所有股票
df = pro.hk_daily(trade_date='20190904')

```

数据示例

```
      ts_code trade_date   open  ...  pct_chg         vol        amount
0    00001.HK   20190904  66.90  ...     3.45   8212577.0  5.619534e+08
1    00001.HK   20190903  66.40  ...    -0.52   3905632.0  2.598397e+08
2    00001.HK   20190902  67.50  ...    -0.71   6547427.0  4.397896e+08
3    00001.HK   20190830  69.60  ...    -0.73   7731576.0  5.299299e+08
4    00001.HK   20190829  69.05  ...     0.36   7902900.0  5.428812e+08
5    00001.HK   20190828  69.05  ...    -1.08   8973397.0  6.183098e+08
6    00001.HK   20190827  70.50  ...     0.00   6286907.0  4.359607e+08
7    00001.HK   20190826  69.40  ...    -1.91   8054636.0  5.554714e+08
8    00001.HK   20190823  70.45  ...    -0.42   5449506.0  3.863469e+08
9    00001.HK   20190822  71.50  ...    -0.49   5299641.0  3.750118e+08
10   00001.HK   20190821  70.00  ...     1.71   7045145.0  5.019940e+08
11   00001.HK   20190820  70.60  ...     0.21   7844342.0  5.522724e+08
12   00001.HK   20190819  68.30  ...     3.02  10498548.0  7.332229e+08
13   00001.HK   20190816  66.30  ...     2.03   8311992.0  5.599711e+08
14   00001.HK   20190815  64.40  ...     2.23   9695771.0  6.378087e+08
15   00001.HK   20190814  66.25  ...    -1.29  10816336.0  7.058398e+08
16   00001.HK   20190813  67.00  ...    -2.58  12104207.0  8.037089e+08
17   00001.HK   20190812  67.35  ...    -0.37   5775321.0  3.921880e+08
18   00001.HK   20190809  67.65  ...    -0.15   5996124.0  4.078781e+08
19   00001.HK   20190808  67.65  ...     0.52   8208977.0  5.587438e+08
20   00001.HK   20190807  68.20  ...    -1.31   8215702.0  5.567659e+08

```
