# 港股复权行情

**文档ID**: 339
**原始链接**: https://tushare.pro/document/2?doc_id=339

---

## 港股复权行情

接口：hk_daily_adj，可以通过数据工具调试和查看数据。描述：获取港股复权行情，提供股票股本、市值和成交及换手多个数据指标限量：单次最大可以提取6000条数据，可循环获取全部，支持分页提取要求：120积分可以试用查看数据，开通正式权限请参考权限说明文档

注：港股复权逻辑是：价格 * 复权因子 = 复权价格，比如close * adj_factor = 前复权收盘价。复权因子历史数据可能除权等被刷新，请注意动态更新。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码（e.g. 00001.HK）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期（YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期（YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌额</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>None</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>vwap</td>
<td>float</td>
<td>Y</td>
<td>平均价</td>
</tr>
<tr>
<td>adj_factor</td>
<td>float</td>
<td>Y</td>
<td>复权因子</td>
</tr>
<tr>
<td>turnover_ratio</td>
<td>float</td>
<td>Y</td>
<td>换手率(基于总股本)</td>
</tr>
<tr>
<td>free_share</td>
<td>None</td>
<td>Y</td>
<td>流通股本</td>
</tr>
<tr>
<td>total_share</td>
<td>None</td>
<td>Y</td>
<td>总股本</td>
</tr>
<tr>
<td>free_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取单一股票行情
df = pro.hk_daily_adj(ts_code='00001.HK', start_date='20240101', end_date='20240722')

#获取某一日某个交易所的全部股票
df = pro.hk_daily_adj(trade_date='20240722')

```

数据示例

```
      ts_code trade_date  close pre_close      vol adj_factor turnover_ratio
0    00001.HK   20240722  40.95     40.90  2799284     1.0000           0.07
1    00001.HK   20240719  40.90     40.85  6472801     1.0000           0.17
2    00001.HK   20240718  40.85     40.50  5498406     1.0000           0.14
3    00001.HK   20240717  40.50     39.95  4151953     1.0000           0.11
4    00001.HK   20240716  39.95     40.15  3978223     1.0000           0.10
..        ...        ...    ...       ...      ...        ...            ...
131  00001.HK   20240108  38.91     39.05  3271763     0.9572           0.09
132  00001.HK   20240105  39.05     39.24  2731319     0.9572           0.07
133  00001.HK   20240104  39.24     39.58  2800255     0.9572           0.07
134  00001.HK   20240103  39.58     39.48  3498817     0.9572           0.09
135  00001.HK   20240102  39.48     40.06  2782895     0.9572           0.07

[136 rows x 7 columns]

```
