# 港股复权因子

**文档ID**: 401
**原始链接**: https://tushare.pro/document/2?doc_id=401

---

## 港股复权因子

接口：hk_adjfactor描述：获取港股每日复权因子数据，每天滚动刷新限量：单次最大6000行数据，可以根据日期循环权限：本接口是在开通港股日线权限后自动获取权限，权限请参考权限说明文档

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>cum_adjfactor</td>
<td>float</td>
<td>Y</td>
<td>累计复权因子</td>
</tr>
<tr>
<td>close_price</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取港股单一股票复权因子
df = pro.hk_adjfactor(ts_code='00001.HK', start_date='20240101', end_date='20251022')

#获取港股某一日全部股票的复权因子
df = pro.hk_adjfactor(trade_date='20251031')

```

数据示例

```
       ts_code trade_date cum_adjfactor close_price
0     00380.HK   20251031      1.000000    0.150000
1     00698.HK   20251031      1.000000    4.610000
2     00865.HK   20251031      1.000000    0.038000
3     08111.HK   20251031      1.000000    0.068000
4     00039.HK   20251031      1.000000    0.088000
...        ...        ...           ...         ...
4086  01384.HK   20251031      1.000000  113.700000
4087  02954.HK   20251031      1.000000    0.265000
4088  03460.HK   20251031      1.000000    7.440000
4089  83460.HK   20251031      1.000000    6.840000
4090  09460.HK   20251031      1.000000    0.960000

```
