# 港股基础信息

**文档ID**: 191
**原始链接**: https://tushare.pro/document/2?doc_id=191

---

## 港股列表

接口：hk_basic描述：获取港股列表信息数量：单次可提取全部在交易的港股列表数据积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>list_status</td>
<td>str</td>
<td>N</td>
<td>上市状态 L上市 D退市 P暂停上市 ，默认L</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td></td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票简称</td>
</tr>
<tr>
<td>fullname</td>
<td>str</td>
<td>Y</td>
<td>公司全称</td>
</tr>
<tr>
<td>enname</td>
<td>str</td>
<td>Y</td>
<td>英文名称</td>
</tr>
<tr>
<td>cn_spell</td>
<td>str</td>
<td>Y</td>
<td>拼音</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>Y</td>
<td>市场类别</td>
</tr>
<tr>
<td>list_status</td>
<td>str</td>
<td>Y</td>
<td>上市状态</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
<tr>
<td>delist_date</td>
<td>str</td>
<td>Y</td>
<td>退市日期</td>
</tr>
<tr>
<td>trade_unit</td>
<td>float</td>
<td>Y</td>
<td>交易单位</td>
</tr>
<tr>
<td>isin</td>
<td>str</td>
<td>Y</td>
<td>ISIN代码</td>
</tr>
<tr>
<td>curr_type</td>
<td>str</td>
<td>Y</td>
<td>货币代码</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取全部可交易股票基础信息
df = pro.hk_basic()

#获取全部退市股票基础信息
df = pro.hk_basic(list_status='D')

```

数据示例

```
       ts_code             name  ...          isin curr_type
0     00001.HK               长和  ...  KYG217651051       HKD
1     00002.HK             中电控股  ...  HK0002007356       HKD
2     00003.HK           香港中华煤气  ...  HK0003000038       HKD
3     00004.HK            九龙仓集团  ...  HK0004000045       HKD
4     00005.HK             汇丰控股  ...  GB0005405286       HKD
5     00006.HK             电能实业  ...  HK0006000050       HKD
6     00007.HK           香港金融集团  ...  BMG4613K1099       HKD
7     00008.HK             电讯盈科  ...  HK0008011667       HKD
8     00009.HK             九号运通  ...  BMG6547Y1057       HKD
9     00010.HK             恒隆集团  ...  HK0010000088       HKD
10    00011.HK             恒生银行  ...  HK0011000095       HKD
11    00012.HK             恒基地产  ...  HK0012000102       HKD
12    00014.HK             希慎兴业  ...  HK0014000126       HKD
13    00015.HK             盈信控股  ...  BMG932121434       HKD
14    00016.HK            新鸿基地产  ...  HK0016000132       HKD
15    00017.HK            新世界发展  ...  HK0017000149       HKD
16    00018.HK           东方报业集团  ...  HK0018000155       HKD
17    00019.HK          太古股份公司A  ...  HK0019000162       HKD
18    00020.HK              会德丰  ...  HK0020000177       HKD
19    00021.HK          大中华地产控股  ...  HK0000132420       HKD
20    00022.HK             茂盛控股  ...  BMG6051D1175       HKD
```
