# 港股利润表

**文档ID**: 389
**原始链接**: https://tushare.pro/document/2?doc_id=389

---

## 港股利润表

接口：hk_income，可以通过数据工具调试和查看数据。描述：获取港股上市公司财务利润表数据权限：需单独开权限或有15000积分，具体权限信息请参考权限列表提示：当前接口按单只股票获取其历史数据，单次请求最大返回10000行数据，可循环提取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>报告期(格式：YYYYMMDD）</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>N</td>
<td>指标名（如：营业额）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告结束始日期（格式：YYYYMMDD）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>报告期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>ind_name</td>
<td>str</td>
<td>Y</td>
<td>财务科目名称</td>
</tr>
<tr>
<td>ind_value</td>
<td>float</td>
<td>Y</td>
<td>财务科目值</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取腾讯控股00700.HK股票的2024年度利润表数据
df = pro.hk_income(ts_code='00700.HK', period='20241231')

#获取腾讯控股00700.HK股票利润表历年营业额数据
df = pro.hk_income(ts_code='00700.HK', ind_name='营业额')

```

数据样例

```
     ts_code  end_date  name              ind_name     ind_value
0   00700.HK  20241231  腾讯控股             营业额  6.524980e+11
1   00700.HK  20241231  腾讯控股      其他全面收益其他项目  8.787500e+10
2   00700.HK  20241231  腾讯控股            营运收入  6.602570e+11
3   00700.HK  20241231  腾讯控股            营运支出  3.110110e+11
4   00700.HK  20241231  腾讯控股              毛利  3.492460e+11
5   00700.HK  20241231  腾讯控股            其他收益  8.002000e+09
6   00700.HK  20241231  腾讯控股         销售及分销费用  3.638800e+10
7   00700.HK  20241231  腾讯控股          其他营业收入  7.759000e+09
8   00700.HK  20241231  腾讯控股            经营溢利  2.080990e+11
9   00700.HK  20241231  腾讯控股            利息收入  1.600400e+10
10  00700.HK  20241231  腾讯控股            融资成本  1.198100e+10
11  00700.HK  20241231  腾讯控股        应占联营公司溢利  2.517600e+10
12  00700.HK  20241231  腾讯控股          溢利其他项目  4.187000e+09
13  00700.HK  20241231  腾讯控股           除税前溢利  2.414850e+11
14  00700.HK  20241231  腾讯控股              税项  4.501800e+10
15  00700.HK  20241231  腾讯控股      持续经营业务税后利润  1.964670e+11
16  00700.HK  20241231  腾讯控股           除税后溢利  1.964670e+11
17  00700.HK  20241231  腾讯控股          少数股东损益  2.394000e+09
18  00700.HK  20241231  腾讯控股          股东应占溢利  1.940730e+11
19  00700.HK  20241231  腾讯控股          每股基本盈利  2.094000e+01
20  00700.HK  20241231  腾讯控股          每股摊薄盈利  2.049000e+01
21  00700.HK  20241231  腾讯控股           非运算项目 -3.110110e+11
22  00700.HK  20241231  腾讯控股          其他全面收益  8.787500e+10
23  00700.HK  20241231  腾讯控股          全面收益总额  2.843420e+11
24  00700.HK  20241231  腾讯控股   非控股权益应占全面收益总额  5.333000e+09
25  00700.HK  20241231  腾讯控股  本公司拥有人应占全面收益总额  2.790090e+11
26  00700.HK  20241231  腾讯控股            行政开支  1.127610e+11

```
