# 港股分钟行情

**文档ID**: 304
**原始链接**: https://tushare.pro/document/2?doc_id=304

---

## 港股分钟行情

接口：hk_mins描述：港股分钟数据，支持1min/5min/15min/30min/60min行情，提供Python SDK和 http Restful API两种方式限量：单次最大8000行数据，可以通过股票代码和日期循环获取权限：120积分可以调取2次接口查看数据，正式权限请参阅权限说明。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码，e.g.00001.HK</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>分钟频度（1min/5min/15min/30min/60min）</td>
</tr>
<tr>
<td>start_date</td>
<td>datetime</td>
<td>N</td>
<td>开始日期 格式：2023-03-13 09:00:00</td>
</tr>
<tr>
<td>end_date</td>
<td>datetime</td>
<td>N</td>
<td>结束时间 格式：2023-03-13 19:00:00</td>
</tr>
</tbody></table>
freq参数说明

<table>
<thead>
<tr>
<th>freq</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1min</td>
<td>1分钟</td>
</tr>
<tr>
<td>5min</td>
<td>5分钟</td>
</tr>
<tr>
<td>15min</td>
<td>15分钟</td>
</tr>
<tr>
<td>30min</td>
<td>30分钟</td>
</tr>
<tr>
<td>60min</td>
<td>60分钟</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.hk_mins(ts_code='00001.HK', freq='1min', start_date='2023-03-13 09:00:00', end_date='2023-03-13 19:00:00')

```

数据样例

```
  ts_code                trade_time  open  close   high    low       vol      amount
0    00001.HK  2023-03-13 16:10:00  48.80  48.75  48.80  48.75  375500.0  18305625.0
1    00001.HK  2023-03-13 16:00:00  48.80  48.80  48.85  48.75   12000.0    585575.0
2    00001.HK  2023-03-13 15:59:00  48.80  48.80  48.80  48.75   12500.0    609825.0
3    00001.HK  2023-03-13 15:58:00  48.85  48.80  48.85  48.75    9500.0    463725.0
4    00001.HK  2023-03-13 15:57:00  48.80  48.80  48.85  48.75   24000.0   1171450.0
..        ...                  ...    ...    ...    ...    ...       ...         ...
327  00001.HK  2023-03-13 09:34:00  47.40  47.35  47.45  47.35   17000.0    805975.0
328  00001.HK  2023-03-13 09:33:00  47.55  47.40  47.55  47.40   11000.0    521725.0
329  00001.HK  2023-03-13 09:32:00  47.60  47.55  47.70  47.50   52500.0   2497550.0
330  00001.HK  2023-03-13 09:31:00  47.30  47.60  47.60  47.30   44229.0   2097256.7
331  00001.HK  2023-03-13 09:30:00  47.30  47.30  47.30  47.30  469900.0  22298550.0

```
