# 温州民间借贷利率

**文档ID**: 173
**原始链接**: https://tushare.pro/document/2?doc_id=173

---

## 温州民间借贷利率

接口：wz_index描述：温州民间借贷利率，即温州指数限量：不限量，一次可取全部指标全部历史数据积分：用户需要积攒2000积分可调取，具体请参阅积分获取办法数据来源：温州指数网注：温州指数 ，即温州民间融资综合利率指数，该指数及时反映民间金融交易活跃度和交易价格。该指数样板数据主要采集于四个方面：由温州市设立的几百家企业测报点，把各自借入的民间资本利率通过各地方金融办不记名申报收集起来；对各小额贷款公司借出的利率进行加权平均；融资性担保公司如典当行在融资过程中的利率，由温州经信委和商务局负责测报；民间借贷服务中心的实时利率。这些利率进行加权平均，就得出了“温州指数”。它是温州民间融资利率的风向标。2012年12月7日，温州指数正式对外发布。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>comp_rate</td>
<td>float</td>
<td>Y</td>
<td>温州民间融资综合利率指数 (%，下同)</td>
</tr>
<tr>
<td>center_rate</td>
<td>float</td>
<td>Y</td>
<td>民间借贷服务中心利率</td>
</tr>
<tr>
<td>micro_rate</td>
<td>float</td>
<td>Y</td>
<td>小额贷款公司放款利率</td>
</tr>
<tr>
<td>cm_rate</td>
<td>float</td>
<td>Y</td>
<td>民间资本管理公司融资价格</td>
</tr>
<tr>
<td>sdb_rate</td>
<td>float</td>
<td>Y</td>
<td>社会直接借贷利率</td>
</tr>
<tr>
<td>om_rate</td>
<td>float</td>
<td>Y</td>
<td>其他市场主体利率</td>
</tr>
<tr>
<td>aa_rate</td>
<td>float</td>
<td>Y</td>
<td>农村互助会互助金费率</td>
</tr>
<tr>
<td>m1_rate</td>
<td>float</td>
<td>Y</td>
<td>温州地区民间借贷分期限利率（一月期）</td>
</tr>
<tr>
<td>m3_rate</td>
<td>float</td>
<td>Y</td>
<td>温州地区民间借贷分期限利率（三月期）</td>
</tr>
<tr>
<td>m6_rate</td>
<td>float</td>
<td>Y</td>
<td>温州地区民间借贷分期限利率（六月期）</td>
</tr>
<tr>
<td>m12_rate</td>
<td>float</td>
<td>Y</td>
<td>温州地区民间借贷分期限利率（一年期）</td>
</tr>
<tr>
<td>long_rate</td>
<td>float</td>
<td>Y</td>
<td>温州地区民间借贷分期限利率（长期）</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.wz_index(start_date='20180101', end_date='20190401')

```

数据样例

```
           date  comp_rate  center_rate  micro_rate  cm_rate  sdb_rate  om_rate  \
0    20180102      15.05        16.58       14.74     15.0     14.43    22.99   
1    20180103      15.58        14.72       15.59     15.0     14.43    22.99   
2    20180104      15.91        15.73       15.91     15.0     14.43    22.99   
3    20180105      15.26        17.19       13.89     15.0     14.23    23.02   
4    20180108      16.26        16.70       16.30     15.0     14.23    23.02   
5    20180109      16.42        19.01       17.14     15.0     14.23    23.02   
6    20180110      15.92        13.30       16.97     15.0     14.23    23.02   
7    20180111      15.98        15.57       15.47     15.0     14.23    23.02   
8    20180112      15.44        15.46       15.85     15.0     13.91    20.48   
9    20180115      15.27        13.82       16.38     15.0     13.91    20.48   
10   20180116      15.12        14.94       15.84     15.0     13.91    20.48   
11   20180117      15.13        14.13       14.34     15.0     13.91    20.48   
12   20180118      15.33        16.31       15.19     15.0     13.91    20.48   
13   20180119      15.36        13.97       17.09     15.0     14.19    22.27   
14   20180122      16.03        14.66       18.18     15.0     14.19    22.27   
15   20180123      16.18        14.57       18.29     15.0     14.19    22.27   
16   20180124      15.25        15.82       15.38     15.0     14.19    22.27   
17   20180125      15.17        16.12       15.90     15.0     14.19    22.27   
18   20180126      15.99        14.15       17.40     15.0     14.67    23.11   
19   20180129      16.02        14.08       15.17     15.0     14.67    23.11   

     aa_rate  m1_rate  m3_rate  m6_rate  m12_rate  long_rate  
0      12.26    17.35    16.72    14.87     12.97      15.78  
1      12.87    20.93    15.94    15.07     14.04      15.91  
2      14.11    20.79    16.33    15.12     14.23      16.22  
3      15.82    21.09    14.71    14.04     14.30      13.86  
4      15.22    21.35    18.79    13.42     15.02      13.88  
5      14.78    21.03    18.01    14.46     15.28      13.64  
6      14.56    21.24    17.94    14.19     14.42      13.27  
7      13.44    20.82    17.66    14.08     14.62      13.31  
8      15.66    19.70    15.14    15.33     13.27      15.71  
9      15.37    19.59    14.66    14.48     14.17      15.49  
10     13.32    18.30    17.20    14.73     13.52      14.97  
11     13.15    19.33    14.18    13.95     14.23      16.98  
12     13.28    19.99    14.60    14.23     14.06      17.46  
13     13.97    21.34    14.27    14.85     14.03      16.88  
14     15.79    20.81    17.37    14.88     14.08      16.03  
15     13.15    21.43    16.25    14.91     14.14      15.60  
16     12.48    21.41    15.48    14.88     13.58      16.07  
17     14.94    21.24    16.57    14.47     13.84      16.28  
18     14.71    21.34    15.13    15.52     14.61      15.08  
19     14.71    21.44    17.47    14.88     13.87      14.49 

```
