# 深证易互动问答

**文档ID**: 367
**原始链接**: https://tushare.pro/document/2?doc_id=367

---

## 深证互动易

接口：irm_qa_sz，历史数据开始于2010年10月。描述：互动易是由深交所官方推出,供投资者与上市公司直接沟通的平台,一站式公司资讯汇集,提供第一手的互动问答、投资者关系信息、公司声音等内容。限量：单次请求最大返回3000行数据，可根据股票代码，日期等参数循环提取全部数据权限：用户后120积分可以试用，正式权限为10000积分，或申请单独开权限，请参考权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式YYYYMMDD，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>pub_date</td>
<td>str</td>
<td>N</td>
<td>发布开始日期(格式：2025-06-03 16:43:03)</td>
</tr>
<tr>
<td>pub_date</td>
<td>str</td>
<td>N</td>
<td>发布结束日期(格式：2025-06-03 18:43:23)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>公司名称</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>发布时间</td>
</tr>
<tr>
<td>q</td>
<td>str</td>
<td>Y</td>
<td>问题</td>
</tr>
<tr>
<td>a</td>
<td>str</td>
<td>Y</td>
<td>回复</td>
</tr>
<tr>
<td>pub_time</td>
<td>str</td>
<td>Y</td>
<td>答复时间</td>
</tr>
<tr>
<td>industry</td>
<td>str</td>
<td>Y</td>
<td>涉及行业</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

#获取2025年2月12日深证互动易的问答文本
df = pro.irm_qa_sz(ann_date='20250212')

```

数据样例

```
     ts_code  name   trade_date                                                  q                                                  a             pub_time         industry
0   002254  泰和新材   20250212    请问宋总公司有无F12芳纶的研究成果，有无选择一家很有发展前途的公司并购重组，把公司做大做强。            您好，非常感谢您对公司的关注。公司正研发类似产品，以丰富公司的产品品类。谢谢！  2025-02-12 21:46:32              制造业
1   002122  汇洲智能   20250212                尊敬的董秘，能否回答一下，公司控股孙公司热热文化与幻方量化是否有合作？  您好，经核查，公司及控股公司热热文化与“幻方量化”无合作关系。《证券时报》和巨潮资讯网（ht...  2025-02-12 15:02:17              制造业
2   300675   建科院   20250212                 公司子公司雄安绿研智库有没深度参与部署雄安中心deepseek建模？               您好，公司及子公司雄安绿研智库有限公司未知悉问题所涉事项。感谢您的关注。  2025-02-12 18:31:18       科学研究和技术服务业
3   002531  天顺风能   20250212  朱总、咱公司德国的生产基地进展如何…？什么时候量产？咱公司脚踏实地稳步前行…是否打算向东盟扩...  投资者你好，德国基地建设顺利推进，具体投产时间以定期报告披露为准。目前公司暂无东盟生产基地以...  2025-02-12 17:59:40              制造业
4   301162  国能日新   20250212  尊敬的董秘您好，目前国内以DEEPSEEK为代表的人工智能快速发展，公司作为功率预测相关的服...  您好，DeepSeek国产开源大模型将为众多的行业应用在技术创新优化、成本控制和服务能力上带...  2025-02-12 17:34:33  信息传输、软件和信息技术服务业
5   300856  科思股份   20250212                      请问，截至2025年二月 10日公司的股东总数是多少？谢谢     尊敬的投资者，您好！截至2025年2月10日，公司股东人数为22,400余户。感谢您的关注！  2025-02-12 17:33:46              制造业
6   300558  贝达药业   20250212  请问贵公司最近股价离奇连续暴跌，公司是否存在重大经营问题未披露？\n另外，公司在药物研发上是...  您好！目前，公司生产经营活动一切正常，不存在应披露未披露事项。短期内股价受市场因素等影响而波...  2025-02-12 17:09:35              制造业
7   301399  英特科技   20250212                                       公司目前股东人数是多少？  您好，根据公司2024年第三季度报告，报告期末普通股股东总数为11,007户。公司股东户数将...  2025-02-12 16:02:15              制造业
8   300597  吉大通信   20250212                                你好，请问贵公司是否与阿里巴巴有合作？                          感谢您的关注！截至目前公司与阿里巴巴暂无直接合作。  2025-02-12 15:59:17  信息传输、软件和信息技术服务业
9   002926  华西证券   20250212                尊敬的董秘，请问截止2025年2月10日，最新的股东户数是多少，谢谢。            尊敬的投资者，公司在定期报告中披露股东人数，请留意公司定期报告。感谢您的关注。  2025-02-12 15:58:48              金融业
10  002480  新筑股份   20250212                           请问截止2025年2月10日，公司股东人数多少？                  您好，截止2025年2月10日，公司股东户数为32,833，谢谢。  2025-02-12 15:56:08              制造业
11  301125  腾亚精工   20250212                      请问，截至2025年二月 10日公司的股东总数是多少？谢谢  尊敬的投资者，您好，根据中国证券登记结算有限责任公司深圳分公司最新下发的股东名册，截至202...  2025-02-12 15:55:07              制造业
12  002203  海亮股份   20250212  董秘：贵司是国内同行业的头部企业，且在国际相关行业发展中拥有较强的竞争力地位。特别是近年来，...  您好！非常感谢您对公司的关注。公司股价受多重因素影响，存在短期不确定性。公司专注自身业务发展...  2025-02-12 17:02:11              制造业
13  003041  真爱美家   20250212                      请问，截至2025年二月 10日公司的股东总数是多少？谢谢  尊敬的投资者： 感谢您对真爱美家的关注！ 根据中证登最新数据，截至2025年2月10日，合并...  2025-02-12 15:53:38              制造业
14  002182  宝武镁业   20250212                        您好！请问截至2月10日收盘公司股东人数是多少，谢谢！                     您好,截至2025年2月10日的股东户数为59093,谢谢。  2025-02-12 15:52:07              制造业
15  300534  陇神戎发   20250212                       董秘您好，请问截止到2月10日公司股东人数是多少？谢谢。  尊敬的投资者您好！根据中国证券登记结算有限责任公司提供的数据，截止2025年2月10日公司股...  2025-02-12 15:48:30              制造业
16  300760  迈瑞医疗   20250212                         公司Ai应用是否可以接入或已经接入deepseek？  您好，谢谢关注。迈瑞致力于打造科室级应用的垂直大模型，从基座到垂直应用，这是发挥迈瑞临床优势...  2025-02-12 16:56:09              制造业
17  000785  居然智家   20250212  贵司除了在澳门，新加坡和柬埔寨有卖场，接下来几年里，还有打算在哪些地方开店的计划吗？能否透露...  尊敬的投资人您好，2024年公司先后在柬埔寨和澳门开设两家卖场，新加坡没有卖场。详情请关注公...  2025-02-12 15:35:57         租赁和商务服务业
18  002250  联化科技   20250212                               公司的空冷设备能不能应用于数据中心冷却？               您好！公司会积极增强研发实力和技术储备，做大做强公司业务。感谢您的关注！  2025-02-12 16:41:46              制造业
19  002387   维信诺   20250212                            公司现在，还有多少股民。重组进展到那个阶段了。  感谢您的关注。截至2025年2月10日，公司股东人数为74,343户。公司正在持续推进重大资...  2025-02-12 15:34:59              制造业
20  002250  联化科技   20250212                               贵司有没有接入Deepseek 大模型？  您好！公司暂未接入Deepseek，公司会积极增强研发实力和技术储备，做大做强公司业务。感谢...  2025-02-12 16:41:21              制造业
21  002567   唐人神   20250212                        董秘你好 请问公司2025年生猪完全养殖成本目标是多少  谢谢您的关注。公司始终致力于低成本生产体系建设，目前公司主要通过优化饲料配方、降低原料采购价...  2025-02-12 15:34:27              制造业
22  300989  蕾奥规划   20250212                      请问，截至2025年二月 10日公司的股东总数是多少？谢谢  尊敬的投资者，您好！截止至2025年2月10日，公司股东总户数9,267户，其中机构股东总户...  2025-02-12 15:30:46       科学研究和技术服务业
23  003031  中瓷电子   20250212  董秘辛苦了，精密陶瓷零部件用氧化铝、氮化铝核心材料和配套的金属化体系在如火如荼的半导体产业有...  尊敬的投资者，您好。公司精密陶瓷零部件是采用氧化铝、氮化铝等先进陶瓷经精密加工后制备的半导体...  2025-02-12 16:25:55              制造业

```
