# 深圳市场每日交易情况

**文档ID**: 268
**原始链接**: https://tushare.pro/document/2?doc_id=268

---

## 深圳市场每日交易概况

接口：sz_daily_info描述：获取深圳市场每日交易概况限量：单次最大2000，可循环获取，总量不限制权限：用户积2000积分可调取， 频次有限制，积分越高每分钟调取频次越高，5000积分以上频次相对较高，积分获取方法请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
ts_code主要包括：

<table>
<thead>
<tr>
<th>板块代码（TS_CODE）</th>
<th>板块说明</th>
<th>数据开始日期</th>
</tr>
</thead>
<tbody><tr>
<td>股票</td>
<td>深圳市场股票总和</td>
<td>20080102</td>
</tr>
<tr>
<td>主板A股</td>
<td>深圳主板A股情况</td>
<td>20080102</td>
</tr>
<tr>
<td>主板B股</td>
<td>深圳主板B股情况</td>
<td>20080102</td>
</tr>
<tr>
<td>创业板A股</td>
<td>深圳创业板情况</td>
<td>20080102</td>
</tr>
<tr>
<td>基金</td>
<td>深圳市场基金总和</td>
<td>20080102</td>
</tr>
<tr>
<td>ETF</td>
<td>深圳ETF交易情况</td>
<td>20080102</td>
</tr>
<tr>
<td>LOF</td>
<td>深圳LOF交易情况</td>
<td>20080102</td>
</tr>
<tr>
<td>封闭式基金</td>
<td>深圳封闭式基金交易情况</td>
<td>20080102</td>
</tr>
<tr>
<td>基础设施基金</td>
<td>深圳RETIS基金交易情况</td>
<td>20210621</td>
</tr>
<tr>
<td>债券</td>
<td>深圳债券市场总和</td>
<td>20080102</td>
</tr>
<tr>
<td>债券现券</td>
<td>深圳现券交易情况</td>
<td>20080102</td>
</tr>
<tr>
<td>债券回购</td>
<td>深圳债券回购交易情况</td>
<td>20080102</td>
</tr>
<tr>
<td>ABS</td>
<td>深圳ABS交易情况</td>
<td>20080102</td>
</tr>
<tr>
<td>期权</td>
<td>深圳期权总和</td>
<td>20080102</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td></td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>市场类型</td>
</tr>
<tr>
<td>count</td>
<td>int</td>
<td>Y</td>
<td>股票个数</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额</td>
</tr>
<tr>
<td>vol</td>
<td>None</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股票</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值</td>
</tr>
</tbody></table>
接口示例

```

#获取深圳市场20200320交易数据
df = pro.sz_daily_info(trade_date='20200320')

#获取深圳市场交易情况
df = pro.sz_daily_info(trade_date='20200320', ts_code='股票')

```

数据示例

```
        trade_date ts_code  count           amount          vol            total_share           total_mv                       float_share           float_mv
0    20200320     ABS    541     504804930.72      4843368     5004918501.00    472061975980.53     5004918501.00    472061975980.53
1    20200320     ETF     86   10960679423.49   8003777630    99210471704.00    153213629317.87    99210471704.00    153213629317.87
2    20200320     LOF    249    1202089548.18   2029753496    42142809618.00     37448346544.52    42142809618.00     37448346544.52
3    20200320     中小板    948  192532630530.61  17921759322   935567938002.00   9958667914529.80   733962624249.00   7650247307737.14
4    20200320    主板A股    460   96090513214.35  10211776104   805063702685.00   7028091416467.25   705056618283.00   6210675551047.30
5    20200320    主板B股     46     102202260.47     18980673    12676603056.00     45168496735.09    12546456576.00     44469314083.06
6    20200320      债券   6558  170830629708.59   1386734301              None               None              None               None
7    20200320    债券回购     12   97006833500.00    970873520              None               None              None               None
8    20200320    债券现券   6005   73318991277.87    411017413   342674191457.00  34325230393533.29    17044369724.00   1754190029091.49
9    20200320    分级基金    208    1162654854.49   1242992337    42039852135.00     39427148230.75    42039852135.00     39427148230.75
10   20200320   创业板A股    802  147576399405.00   9965011014   412404300212.00   6649471689968.69   315924775647.00   4495524754972.39
11   20200320      基金    544   13326523128.60  11276535453   183401248132.00    230833320937.40   183401248132.00    230833320937.40
12   20200320   封闭式基金      1       1099302.43        11990        8114675.00       744196844.25        8114675.00       744196844.25
13   20200320      期权    128     388976963.00       447009              None               None              None               None
14   20200320      股票   2256  436301745410.43  38117527113  2165712543955.00  23681399517700.83  1767490474755.00  18400916927839.89
```
