# 涨跌停和炸板数据

**文档ID**: 298
**原始链接**: https://tushare.pro/document/2?doc_id=298

---

## 涨跌停列表（新）

接口：limit_list_d描述：获取A股每日涨跌停、炸板数据情况，数据从2020年开始（不提供ST股票的统计）限量：单次最大可以获取2500条数据，可通过日期或者股票循环提取积分：5000积分每分钟可以请求200次每天总量1万次，8000积分以上每分钟500次每天总量不限制，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>limit_type</td>
<td>str</td>
<td>N</td>
<td>涨跌停类型（U涨停D跌停Z炸板）</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所（SH上交所SZ深交所BJ北交所）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>industry</td>
<td>str</td>
<td>Y</td>
<td>所属行业</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>limit_amount</td>
<td>float</td>
<td>Y</td>
<td>板上成交金额(成交价格为该股票跌停价的所有成交额的总和，涨停无此数据)</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值</td>
</tr>
<tr>
<td>turnover_ratio</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
<tr>
<td>fd_amount</td>
<td>float</td>
<td>Y</td>
<td>封单金额（以涨停价买入挂单的资金总量）</td>
</tr>
<tr>
<td>first_time</td>
<td>str</td>
<td>Y</td>
<td>首次封板时间（跌停无此数据）</td>
</tr>
<tr>
<td>last_time</td>
<td>str</td>
<td>Y</td>
<td>最后封板时间</td>
</tr>
<tr>
<td>open_times</td>
<td>int</td>
<td>Y</td>
<td>炸板次数(跌停为开板次数)</td>
</tr>
<tr>
<td>up_stat</td>
<td>str</td>
<td>Y</td>
<td>涨停统计（N/T T天有N次涨停）</td>
</tr>
<tr>
<td>limit_times</td>
<td>int</td>
<td>Y</td>
<td>连板数（个股连续封板数量）</td>
</tr>
<tr>
<td>limit</td>
<td>str</td>
<td>Y</td>
<td>D跌停U涨停Z炸板</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.limit_list_d(trade_date='20220615', limit_type='U', fields='ts_code,trade_date,industry,name,close,pct_chg,open_times,up_stat,limit_times')

```

数据样例

```
     trade_date ts_code      industry   name  close pct_chg  open_times up_stat  limit_times
0    20220615  000017.SZ     交运设备   深中华A   3.65    9.94           0     1/1            1
1    20220615  000025.SZ     汽车服务  特  力Ａ  29.54   10.02           5   12/23            1
2    20220615  000498.SZ     工程建设   山东路桥  10.41   10.04           3     1/1            1
3    20220615  000502.SZ     房地产服    绿景退   0.69    9.52           2     3/3            3
4    20220615  000532.SZ     综合行业   华金资本  12.69    9.97           0     1/1            1
..        ...        ...      ...    ...    ...     ...         ...     ...          ...
56   20220615  603633.SH     消费电子   徕木股份  14.58   10.04           3     2/4            1
57   20220615  603668.SH     农牧饲渔   天马科技  18.22   10.02           0     2/2            2
58   20220615  603918.SH     互联网服   金桥信息   9.49    9.97           6     1/1            1
59   20220615  603963.SH       中药   大理药业  14.78    9.97           1     1/1            1
60   20220615  605068.SH     汽车零部   明新旭腾  29.03   10.00           1     2/2            2

```
