# 涨停股票连板天梯

**文档ID**: 356
**原始链接**: https://tushare.pro/document/2?doc_id=356

---

## 连板天梯

接口：limit_step描述：获取每天连板个数晋级的股票，可以分析出每天连续涨停进阶个数，判断强势热度限量：单次最大2000行数据，可根据股票代码或者日期循环提取全部积分：8000积分以上每分钟500次，每天总量不限制，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>nums</td>
<td>str</td>
<td>N</td>
<td>连板次数，支持多个输入，例如nums='2,3'</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>名称</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>nums</td>
<td>str</td>
<td>Y</td>
<td>连板次数</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.limit_step(trade_date='20241125')

```

数据样例

```
    ts_code        name trade_date nums
0   000833.SZ  粤桂股份   20241125   11
1   002611.SZ  东方精工   20241125    8
2   600800.SH  渤海化学   20241125    7
3   000801.SZ  四川九洲   20241125    6
4   600889.SH  南京化纤   20241125    6
5   000615.SZ  ST美谷   20241125    5
6   001229.SZ  魅视科技   20241125    5
7   002095.SZ   生意宝   20241125    5
8   002403.SZ   爱仕达   20241125    5
9   600470.SH  六国化工   20241125    5
10  603015.SH  弘讯科技   20241125    5
11  603527.SH  众源新材   20241125    5
12  002103.SZ  广博股份   20241125    4
13  002175.SZ  东方智造   20241125    4
14  002467.SZ   二六三   20241125    4
15  002741.SZ  光华科技   20241125    4
16  002862.SZ  实丰文化   20241125    4
17  003036.SZ  泰坦股份   20241125    4
18  603377.SH  ST东时   20241125    4
19  000573.SZ  粤宏远A   20241125    3
20  002155.SZ  湖南黄金   20241125    3
21  300822.SZ  贝仕达克   20241125    3
22  600105.SH  永鼎股份   20241125    3
23  600405.SH   动力源   20241125    3
24  600410.SH  华胜天成   20241125    3
25  600979.SH  广安爱众   20241125    3
26  000548.SZ  湖南投资   20241125    2
27  000695.SZ  滨海能源   20241125    2
28  000803.SZ  山高环能   20241125    2
29  002045.SZ  国光电器   20241125    2
30  002054.SZ  德美化工   20241125    2
31  002117.SZ  东港股份   20241125    2
32  002638.SZ  勤上股份   20241125    2
33  002640.SZ   跨境通   20241125    2
34  002658.SZ   雪迪龙   20241125    2
35  002820.SZ   桂发祥   20241125    2
36  002877.SZ  智能自控   20241125    2
37  003005.SZ   竞业达   20241125    2
38  300220.SZ  金运激光   20241125    2
39  600228.SH  返利科技   20241125    2
40  600333.SH  长春燃气   20241125    2
41  600615.SH  丰华股份   20241125    2
42  600775.SH  南京熊猫   20241125    2
43  601133.SH  柏诚股份   20241125    2
44  603026.SH  石大胜华   20241125    2
45  603359.SH  东珠生态   20241125    2
46  603585.SH  苏利股份   20241125    2
47  603655.SH  朗博科技   20241125    2
48  603843.SH  正平股份   20241125    2

```
