# 涨停最强板块统计

**文档ID**: 357
**原始链接**: https://tushare.pro/document/2?doc_id=357

---

## 最强板块统计

接口：limit_cpt_list描述：获取每天涨停股票最多最强的概念板块，可以分析强势板块的轮动，判断资金动向限量：单次最大2000行数据，可根据股票代码或者日期循环提取全部积分：8000积分以上每分钟500次，每天总量不限制，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>板块代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>板块名称</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>days</td>
<td>int</td>
<td>Y</td>
<td>上榜天数</td>
</tr>
<tr>
<td>up_stat</td>
<td>str</td>
<td>Y</td>
<td>连板高度</td>
</tr>
<tr>
<td>cons_nums</td>
<td>int</td>
<td>Y</td>
<td>连板家数</td>
</tr>
<tr>
<td>up_nums</td>
<td>str</td>
<td>Y</td>
<td>涨停家数</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅%</td>
</tr>
<tr>
<td>rank</td>
<td>str</td>
<td>Y</td>
<td>板块热点排名</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.limit_cpt_list(trade_date='20241127')

```

数据样例

```
      ts_code    name      trade_date  days up_stat  cons_nums  up_nums pct_chg  rank
0   885728.TI    人工智能   20241127    18    9天7板         9       27  2.8608     1
1   885420.TI    电子商务   20241127     6    9天7板        11       25  1.8973     2
2   885806.TI    华为概念   20241127    34  18天14板         6       21  2.4648     3
3   885418.TI  文化传媒概念   20241127     2    9天7板         6       18  3.5207     4
4   885976.TI    数字经济   20241127     4    9天7板         6       17  2.8993     5
5   885788.TI    网络直播   20241127     6    9天7板         9       17  2.5367     6
6   886019.TI  AIGC概念   20241127     1    9天7板         5       16  4.3615     7
7   885756.TI    芯片概念   20241127     1    7天7板         7       16  2.4840     8
8   885642.TI    跨境电商   20241127     6    9天7板        10       16  2.1974     9
9   885517.TI   机器人概念   20241127    14    6天6板         7       16  2.1272    10
10  885929.TI    专精特新   20241127     8    7天7板         4       16  2.0335    11
11  885709.TI    虚拟现实   20241127     1    9天7板         4       15  3.4553    12
12  885934.TI     元宇宙   20241127     1    9天7板         4       14  3.9264    13
13  885757.TI     区块链   20241127     1  18天14板         5       14  3.1271    14
14  885413.TI      创投   20241127     3  18天14板         7       14  1.7311    15
15  885779.TI    腾讯概念   20241127     1    9天7板         4       13  3.3722    16
16  885876.TI    网红经济   20241127     1    9天7板         5       12  2.9002    17
17  885494.TI    一带一路   20241127     2    9天7板         1       12  1.3427    18
18  885950.TI   虚拟数字人   20241127     1    9天7板         3       11  4.1545    19
19  886013.TI      信创   20241127     2    9天7板         6       11  3.2298    20

```
