# 沪深股通十大成交股

**文档ID**: 48
**原始链接**: https://tushare.pro/document/2?doc_id=48

---

## 沪深股通十大成交股

接口：hsgt_top10描述：获取沪股通、深股通每日前十大成交详细数据，每天18~20点之间完成当日更新

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码（二选一）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（二选一）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>market_type</td>
<td>str</td>
<td>N</td>
<td>市场类型（1：沪市 3：深市）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>股票名称</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>收盘价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>涨跌额</td>
</tr>
<tr>
<td>rank</td>
<td>int</td>
<td>资金排名</td>
</tr>
<tr>
<td>market_type</td>
<td>str</td>
<td>市场类型（1：沪市 3：深市）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>成交金额（元）</td>
</tr>
<tr>
<td>net_amount</td>
<td>float</td>
<td>净成交金额（元）</td>
</tr>
<tr>
<td>buy</td>
<td>float</td>
<td>买入金额（元）</td>
</tr>
<tr>
<td>sell</td>
<td>float</td>
<td>卖出金额（元）</td>
</tr>
</tbody></table>
接口用法

```
pro = ts.pro_api()

pro.hsgt_top10(trade_date='20180725', market_type='1')

```

或者

```

pro.query('hsgt_top10', ts_code='600519.SH', start_date='20180701', end_date='20180725')

```

数据样例

```
  trade_date    ts_code  name       close  change  rank  market_type  \
0   20180725  600009.SH  上海机场   62.69    2.0677     9            1   
1   20180725  600019.SH  宝钢股份    8.62    0.9368     7            1   
2   20180725  600036.SH  招商银行   28.22    1.6937    10            1   
3   20180725  600276.SH  恒瑞医药   71.89    1.2393     5            1   
4   20180725  600519.SH  贵州茅台  743.81   -0.2133     2            1   
5   20180725  600585.SH  海螺水泥   38.23   -0.4427     3            1   
6   20180725  600690.SH  青岛海尔   18.09    0.0000     8            1   
7   20180725  600887.SH  伊利股份   27.54   -1.7131     6            1   
8   20180725  601318.SH  中国平安   62.16    0.6803     1            1   
9   20180725  601888.SH  中国国旅   74.19    5.5184     4            1   

        amount   net_amount          buy         sell  
0  240958518.0   31199144.0  136078831.0  104879687.0  
1  245582396.0   81732606.0  163657501.0   81924895.0  
2  240655550.0  142328622.0  191492086.0   49163464.0  
3  329472455.0  -71519443.0  128976506.0  200495949.0  
4  508590993.0  226149667.0  367370330.0  141220663.0  
5  357946144.0   51215890.0  204581017.0  153365127.0  
6  243840019.0  -55595149.0   94122435.0  149717584.0  
7  296552611.0  -40273759.0  128139426.0  168413185.0  
8  534002916.0  287838388.0  410920652.0  123082264.0  
9  342115066.0  -63262966.0  139426050.0  202689016.0

```
