# 沪深港通股票列表

**文档ID**: 398
**原始链接**: https://tushare.pro/document/2?doc_id=398

---

## 沪深港通股票列表

接口：stock_hsgt，可以通过数据工具调试和查看数据。描述：获取沪深港通股票列表权限：3000积分起提示：每天上午9:20更新，单次请求最大返回2000行数据，可根据类型循环提取,本接口数据从20250812开始

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>Y</td>
<td>类型（参考下表）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始时间</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束时间</td>
</tr>
</tbody></table>
类型说明如下：

<table>
<thead>
<tr>
<th>类型</th>
<th>类型名称</th>
</tr>
</thead>
<tbody><tr>
<td>HK_SZ</td>
<td>深股通(港&gt;深)</td>
</tr>
<tr>
<td>SZ_HK</td>
<td>港股通(深&gt;港)</td>
</tr>
<tr>
<td>HK_SH</td>
<td>沪股通(港&gt;沪)</td>
</tr>
<tr>
<td>SH_HK</td>
<td>港股通(沪&gt;港)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>Y</td>
<td>类型</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>type_name</td>
<td>str</td>
<td>Y</td>
<td>类型名称</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取20250813日深股通的股票列表
df = pro.stock_hsgt(trade_date='20250813',type='HK_SZ')


```

数据样例

```
             ts_code trade_date   type     name type_name
0    001258.SZ   20250813  HK_SZ     立新能源  深股通(港>深)
1     00019.HK   20250813  SZ_HK  太古股份公司A  港股通(深>港)
2    000513.SZ   20250813  HK_SZ     丽珠集团  深股通(港>深)
3    002044.SZ   20250813  HK_SZ     美年健康  深股通(港>深)
4    000338.SZ   20250813  HK_SZ     潍柴动力  深股通(港>深)
..         ...        ...    ...      ...       ...
995  300206.SZ   20250813  HK_SZ     理邦仪器  深股通(港>深)
996   02331.HK   20250813  SH_HK       李宁  港股通(沪>港)
997   01855.HK   20250813  SH_HK     中庆股份  港股通(沪>港)
998  300726.SZ   20250813  HK_SZ     宏达电子  深股通(港>深)
999   06127.HK   20250813  SH_HK     昭衍新药  港股通(沪>港)

```
