# 沪深市场每日交易统计

**文档ID**: 215
**原始链接**: https://tushare.pro/document/2?doc_id=215

---

## 市场交易统计

接口：daily_info描述：获取交易所股票交易统计，包括各板块明细限量：单次最大4000，可循环获取，总量不限制权限：用户积600积分可调取， 频次有限制，积分越高每分钟调取频次越高，5000积分以上频次相对较高，积分获取方法请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>板块代码（请参阅下方列表）</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>股票市场（SH上交所 SZ深交所）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>指定提取字段</td>
</tr>
</tbody></table>
<table>
<thead>
<tr>
<th>板块代码（TS_CODE）</th>
<th>板块名称（TS_NAME）</th>
<th>数据开始日期</th>
</tr>
</thead>
<tbody><tr>
<td>SZ_MARKET</td>
<td>深圳市场</td>
<td>20041231</td>
</tr>
<tr>
<td>SZ_MAIN</td>
<td>深圳主板</td>
<td>20081231</td>
</tr>
<tr>
<td>SZ_A</td>
<td>深圳A股</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_B</td>
<td>深圳B股</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_GEM</td>
<td>创业板</td>
<td>20091030</td>
</tr>
<tr>
<td>SZ_SME</td>
<td>中小企业板</td>
<td>20040602</td>
</tr>
<tr>
<td>SZ_FUND</td>
<td>深圳基金市场</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_FUND_ETF</td>
<td>深圳基金ETF</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_FUND_LOF</td>
<td>深圳基金LOF</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_FUND_CEF</td>
<td>深圳封闭基金</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_FUND_SF</td>
<td>深圳分级基金</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND</td>
<td>深圳债券</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_CN</td>
<td>深圳债券现券</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_REP</td>
<td>深圳债券回购</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_ABS</td>
<td>深圳债券ABS</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_GOV</td>
<td>深圳国债</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_ENT</td>
<td>深圳企业债</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_COR</td>
<td>深圳公司债</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_BOND_CB</td>
<td>深圳可转债</td>
<td>20080103</td>
</tr>
<tr>
<td>SZ_WR</td>
<td>深圳权证</td>
<td>20080103</td>
</tr>
<tr>
<td>----</td>
<td>----</td>
<td>---</td>
</tr>
<tr>
<td>SH_MARKET</td>
<td>上海市场</td>
<td>20190102</td>
</tr>
<tr>
<td>SH_A</td>
<td>上海A股</td>
<td>19910102</td>
</tr>
<tr>
<td>SH_B</td>
<td>上海B股</td>
<td>19920221</td>
</tr>
<tr>
<td>SH_STAR</td>
<td>科创板</td>
<td>20190722</td>
</tr>
<tr>
<td>SH_REP</td>
<td>股票回购</td>
<td>20190102</td>
</tr>
<tr>
<td>SH_FUND</td>
<td>上海基金市场</td>
<td>19901219</td>
</tr>
<tr>
<td>SH_FUND_ETF</td>
<td>上海基金ETF</td>
<td>19901219</td>
</tr>
<tr>
<td>SH_FUND_LOF</td>
<td>上海基金LOF</td>
<td>19901219</td>
</tr>
<tr>
<td>SH_FUND_REP</td>
<td>上海基金回购</td>
<td>19901219</td>
</tr>
<tr>
<td>SH_FUND_CEF</td>
<td>上海封闭式基金</td>
<td>19901219</td>
</tr>
<tr>
<td>SH_FUND_METF</td>
<td>上海交易型货币基金</td>
<td>19901219</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>市场代码</td>
</tr>
<tr>
<td>ts_name</td>
<td>str</td>
<td>Y</td>
<td>市场名称</td>
</tr>
<tr>
<td>com_count</td>
<td>int</td>
<td>Y</td>
<td>挂牌数</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本（亿股）</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股本（亿股）</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值（亿元）</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值（亿元）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>交易金额（亿元）</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量（亿股）</td>
</tr>
<tr>
<td>trans_count</td>
<td>int</td>
<td>Y</td>
<td>成交笔数（万笔）</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>Y</td>
<td>平均市盈率</td>
</tr>
<tr>
<td>tr</td>
<td>float</td>
<td>Y</td>
<td>换手率（％），注：深交所暂无此列</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所（SH上交所 SZ深交所）</td>
</tr>
</tbody></table>
接口示例

```

#获取深圳市场20200320各板块交易数据
df = pro.daily_info(trade_date='20200320', exchange='SZ')

#获取深圳和上海市场20200320各板块交易指定字段的数据
df = pro.daily_info(trade_date='20200320', exchange='SZ,SH', fields='trade_date,ts_name,pe')

```

数据示例

```
    trade_date    ts_code ts_name  com_count  total_share  float_share  \
0   20200320     SZ_GME     创业板        802      4124.04      3159.24   
1   20200320    SZ_MAIN    深市主板        470      8177.40      7176.03   
2   20200320  SZ_MARKET    深圳市场       2220     21657.12     17674.90   
3   20200320     SZ_SME   中小企业板        948      9355.67      7339.62   

    total_mv   float_mv   amount     vol  trans_count     pe    tr exchange  
0   66494.71   44955.24  1475.76   99.65        830.0  50.37   NaN       SZ  
1   70732.59   62551.44   961.92  102.30        554.0  16.12   NaN       SZ  
2  236813.99  184009.16  4363.01     NaN          NaN  25.46  2.18       SZ  
3   99586.67   76502.47  1925.32  179.21       1208.0  27.74   NaN       SZ  
```
