# 每日股本（盘前）

**文档ID**: 329
**原始链接**: https://tushare.pro/document/2?doc_id=329

---

## 股本情况（盘前）

接口：stk_premarket描述：每日开盘前获取当日股票的股本情况，包括总股本和流通股本，涨跌停价格等。限量：单次最大8000条数据，可循环提取权限：与积分无关，需单独开权限

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本（万股）</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股本（万股）</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘价</td>
</tr>
<tr>
<td>up_limit</td>
<td>float</td>
<td>Y</td>
<td>今日涨停价</td>
</tr>
<tr>
<td>down_limit</td>
<td>float</td>
<td>Y</td>
<td>今日跌停价</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取某一日盘前所有股票当日的最新股本
df = pro.stk_premarket(trade_date='20240603')


```

数据示例

```
    trade_date    ts_code  total_share  float_share pre_close up_limit down_limit
0      20240603  001387.SZ   17778.8000    4355.7297    17.000   18.700     15.300
1      20240603  600460.SH  166407.1845  166407.1845    18.790   20.670     16.910
2      20240603  603052.SH   13484.8000    4096.4000    30.270   33.300     27.240
3      20240603  603269.SH   22053.6977   22053.6977    10.140   11.150      9.130
4      20240603  001339.SZ   24974.4000    7157.2575    29.210   32.130     26.290
...         ...        ...          ...          ...       ...      ...        ...
5335   20240603  603567.SH   94196.3592   93954.0524    12.340   13.570     11.110
5336   20240603  301188.SZ   23245.0244   15044.4508    17.740   21.290     14.190
5337   20240603  603939.SH  101057.9797  100811.6102    45.060   49.570     40.550
5338   20240603  300441.SZ   65225.6868   63480.0236     6.460    7.750      5.170
5339   20240603  920002.BJ    3175.2120     475.0000      None   77.840     41.920

```
