# 每日结算参数

**文档ID**: 141
**原始链接**: https://tushare.pro/document/2?doc_id=141

---

## 结算参数

接口：fut_settle描述：获取每日结算参数数据，包括交易和交割费率等限量：单次最大返回1600行数据，可根据日期循环，总量不限制积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （trade_date/ts_code至少需要输入一个参数）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>合约代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>合约代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>settle</td>
<td>float</td>
<td>Y</td>
<td>结算价</td>
</tr>
<tr>
<td>trading_fee_rate</td>
<td>float</td>
<td>Y</td>
<td>交易手续费率</td>
</tr>
<tr>
<td>trading_fee</td>
<td>float</td>
<td>Y</td>
<td>交易手续费</td>
</tr>
<tr>
<td>delivery_fee</td>
<td>float</td>
<td>Y</td>
<td>交割手续费</td>
</tr>
<tr>
<td>b_hedging_margin_rate</td>
<td>float</td>
<td>Y</td>
<td>买套保交易保证金率</td>
</tr>
<tr>
<td>s_hedging_margin_rate</td>
<td>float</td>
<td>Y</td>
<td>卖套保交易保证金率</td>
</tr>
<tr>
<td>long_margin_rate</td>
<td>float</td>
<td>Y</td>
<td>买投机交易保证金率</td>
</tr>
<tr>
<td>short_margin_rate</td>
<td>float</td>
<td>Y</td>
<td>卖投机交易保证金率</td>
</tr>
<tr>
<td>offset_today_fee</td>
<td>float</td>
<td>N</td>
<td>平今仓手续率</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api('your token')

df = pro.fut_settle(trade_date='20181114', exchange='SHFE')

```

数据示例

```
    ts_code     trade_date    settle  trading_fee_rate  trading_fee  \
0    CU1811.SHF   20181114  48840.00             0.050           0.0   
1    CU1812.SHF   20181114  48990.00             0.050           0.0   
2    CU1901.SHF   20181114  48980.00             0.050           0.0   
3    CU1902.SHF   20181114  48980.00             0.050           0.0   
4    CU1903.SHF   20181114  49020.00             0.050           0.0   
5    CU1904.SHF   20181114  49040.00             0.050           0.0   
6    CU1905.SHF   20181114  49150.00             0.050           0.0   
7    CU1906.SHF   20181114  49260.00             0.050           0.0   
8    CU1907.SHF   20181114  49200.00             0.050           0.0   
9    CU1908.SHF   20181114  49370.00             0.050           0.0   
10   CU1909.SHF   20181114  49350.00             0.050           0.0   
11   CU1910.SHF   20181114  49490.00             0.050           0.0   
12   AL1811.SHF   20181114  13695.00             0.000           3.0   
13   AL1812.SHF   20181114  13770.00             0.000           3.0   
14   AL1901.SHF   20181114  13775.00             0.000           3.0   
15   AL1902.SHF   20181114  13810.00             0.000           3.0   
16   AL1903.SHF   20181114  13860.00             0.000           3.0   
17   AL1904.SHF   20181114  13905.00             0.000           3.0   
18   AL1905.SHF   20181114  13950.00             0.000           3.0   
19   AL1906.SHF   20181114  13965.00             0.000           3.0   
20   AL1907.SHF   20181114  14015.00             0.000           3.0 

     delivery_fee  b_hedging_margin_rate  s_hedging_margin_rate  \
0            2.00                   0.20                   0.20   
1            2.00                   0.10                   0.10   
2            2.00                   0.07                   0.07   
3            2.00                   0.07                   0.07   
4            2.00                   0.07                   0.07   
5            2.00                   0.07                   0.07   
6            2.00                   0.07                   0.07   
7            2.00                   0.07                   0.07   
8            2.00                   0.07                   0.07   
9            2.00                   0.07                   0.07   
10           2.00                   0.07                   0.07   
11           2.00                   0.07                   0.07   
12           2.00                   0.20                   0.20   
13           2.00                   0.10                   0.10   
14           2.00                   0.07                   0.07   
15           2.00                   0.07                   0.07   
16           2.00                   0.07                   0.07   
17           2.00                   0.07                   0.07   
18           2.00                   0.07                   0.07   
19           2.00                   0.07                   0.07   
20           2.00                   0.07                   0.07 

     long_margin_rate  short_margin_rate  
0                0.20               0.20  
1                0.10               0.10  
2                0.07               0.07  
3                0.07               0.07  
4                0.07               0.07  
5                0.07               0.07  
6                0.07               0.07  
7                0.07               0.07  
8                0.07               0.07  
9                0.07               0.07  
10               0.07               0.07  
11               0.07               0.07  
12               0.20               0.20  
13               0.10               0.10  
14               0.07               0.07  
15               0.07               0.07  
16               0.07               0.07  
17               0.07               0.07  
18               0.07               0.07  
19               0.07               0.07  
20               0.07               0.07

```
