# 每日筹码及胜率

**文档ID**: 293
**原始链接**: https://tushare.pro/document/2?doc_id=293

---

## 每日筹码及胜率

接口：cyq_perf描述：获取A股每日筹码平均成本和胜率情况，每天18~19点左右更新，数据从2018年开始来源：Tushare社区限量：单次最大5000条，可以分页或者循环提取积分：5000积分每天20000次，10000积分每天200000次，15000积分每天不限总量

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>his_low</td>
<td>float</td>
<td>Y</td>
<td>历史最低价</td>
</tr>
<tr>
<td>his_high</td>
<td>float</td>
<td>Y</td>
<td>历史最高价</td>
</tr>
<tr>
<td>cost_5pct</td>
<td>float</td>
<td>Y</td>
<td>5分位成本</td>
</tr>
<tr>
<td>cost_15pct</td>
<td>float</td>
<td>Y</td>
<td>15分位成本</td>
</tr>
<tr>
<td>cost_50pct</td>
<td>float</td>
<td>Y</td>
<td>50分位成本</td>
</tr>
<tr>
<td>cost_85pct</td>
<td>float</td>
<td>Y</td>
<td>85分位成本</td>
</tr>
<tr>
<td>cost_95pct</td>
<td>float</td>
<td>Y</td>
<td>95分位成本</td>
</tr>
<tr>
<td>weight_avg</td>
<td>float</td>
<td>Y</td>
<td>加权平均成本</td>
</tr>
<tr>
<td>winner_rate</td>
<td>float</td>
<td>Y</td>
<td>胜率</td>
</tr>
</tbody>
</table>
接口用法

```
pro = ts.pro_api()

df = pro.cyq_perf(ts_code='600000.SH', start_date='20220101', end_date='20220429')

```

数据样例

```
      ts_code trade_date his_low his_high cost_5pct cost_95pct weight_avg winner_rate
0   600000.SH   20220429    0.72    12.16      8.18      11.34       9.76        3.52
1   600000.SH   20220428    0.72    12.16      8.24      11.34       9.76        3.08
2   600000.SH   20220427    0.72    12.16      8.30      11.34       9.76        1.71
3   600000.SH   20220426    0.72    12.16      8.34      11.34       9.76        2.02
4   600000.SH   20220425    0.72    12.16      8.36      11.34       9.77        1.44
..        ...        ...     ...      ...       ...        ...        ...         ...
72  600000.SH   20220110    0.72    12.16      8.60      11.36       9.89        7.62
73  600000.SH   20220107    0.72    12.16      8.60      11.36       9.89        7.59
74  600000.SH   20220106    0.72    12.16      8.60      11.36       9.89        3.92
75  600000.SH   20220105    0.72    12.16      8.60      11.36       9.89        5.65
76  600000.SH   20220104    0.72    12.16      8.60      11.36       9.89        3.93

```
