# 每日筹码分布

**文档ID**: 294
**原始链接**: https://tushare.pro/document/2?doc_id=294

---

## 每日筹码分布

接口：cyq_chips描述：获取A股每日的筹码分布情况，提供各价位占比，数据从2018年开始，每天18~19点之间更新当日数据来源：Tushare社区限量：单次最大2000条，可以按股票代码和日期循环提取积分：5000积分每天20000次，10000积分每天200000次，15000积分每天不限总量

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>Y</td>
<td>成本价格</td>
</tr>
<tr>
<td>percent</td>
<td>float</td>
<td>Y</td>
<td>价格占比（%）</td>
</tr>
</tbody>
</table>
接口用法

```
pro = ts.pro_api()

df = pro.cyq_chips(ts_code='600000.SH', start_date='20220101', end_date='20220429')

```

数据样例

```
         ts_code trade_date price percent
0    600000.SH   20220429  8.96    0.56
1    600000.SH   20220429  8.94    0.40
2    600000.SH   20220429  8.92    0.34
3    600000.SH   20220429  8.90    0.32
4    600000.SH   20220429  8.88    0.27
..         ...        ...   ...     ...
995  600000.SH   20220418  7.26    0.01
996  600000.SH   20220418  7.24    0.01
997  600000.SH   20220418  7.22    0.01
998  600000.SH   20220418  7.20    0.01
999  600000.SH   20220418  7.18    0.01

```
