# 榜单数据（开盘啦）

**文档ID**: 347
**原始链接**: https://tushare.pro/document/2?doc_id=347

---

## 开盘啦榜单数据

接口：kpl_list描述：获取开盘啦涨停、跌停、炸板等榜单数据限量：单次最大8000条数据，可根据日期循环获取历史数据积分：5000积分每分钟可以请求200次每天总量1万次，8000积分以上每分钟500次每天总量不限制，具体请参阅积分获取办法

注：开盘啦是一个优秀的专业打板app，有兴趣的用户可以自行下载安装。本接口仅限用于量化研究，如需商业用途，请自行联系开盘APP官方。数据更新时间次日8:30

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>tag</td>
<td>str</td>
<td>N</td>
<td>板单类型（涨停/炸板/跌停/自然涨停/竞价，默认为涨停)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>名称</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>lu_time</td>
<td>str</td>
<td>Y</td>
<td>涨停时间</td>
</tr>
<tr>
<td>ld_time</td>
<td>str</td>
<td>Y</td>
<td>跌停时间</td>
</tr>
<tr>
<td>open_time</td>
<td>str</td>
<td>Y</td>
<td>开板时间</td>
</tr>
<tr>
<td>last_time</td>
<td>str</td>
<td>Y</td>
<td>最后涨停时间</td>
</tr>
<tr>
<td>lu_desc</td>
<td>str</td>
<td>Y</td>
<td>涨停原因</td>
</tr>
<tr>
<td>tag</td>
<td>str</td>
<td>Y</td>
<td>标签</td>
</tr>
<tr>
<td>theme</td>
<td>str</td>
<td>Y</td>
<td>板块</td>
</tr>
<tr>
<td>net_change</td>
<td>float</td>
<td>Y</td>
<td>主力净额(元)</td>
</tr>
<tr>
<td>bid_amount</td>
<td>float</td>
<td>Y</td>
<td>竞价成交额(元)</td>
</tr>
<tr>
<td>status</td>
<td>str</td>
<td>Y</td>
<td>状态（N连板）</td>
</tr>
<tr>
<td>bid_change</td>
<td>float</td>
<td>Y</td>
<td>竞价净额</td>
</tr>
<tr>
<td>bid_turnover</td>
<td>float</td>
<td>Y</td>
<td>竞价换手%</td>
</tr>
<tr>
<td>lu_bid_vol</td>
<td>float</td>
<td>Y</td>
<td>涨停委买额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅%</td>
</tr>
<tr>
<td>bid_pct_chg</td>
<td>float</td>
<td>Y</td>
<td>竞价涨幅%</td>
</tr>
<tr>
<td>rt_pct_chg</td>
<td>float</td>
<td>Y</td>
<td>实时涨幅%</td>
</tr>
<tr>
<td>limit_order</td>
<td>float</td>
<td>Y</td>
<td>封单</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率%</td>
</tr>
<tr>
<td>free_float</td>
<td>float</td>
<td>Y</td>
<td>实际流通</td>
</tr>
<tr>
<td>lu_limit_order</td>
<td>float</td>
<td>Y</td>
<td>最大封单</td>
</tr>
</tbody>
</table>
接口用法

```
pro = ts.pro_api()

df = pro.kpl_list(trade_date='20240927', tag='涨停', fields='ts_code,name,trade_date,tag,theme,status')

```

数据样例

```
       ts_code  name      trade_date tag         theme         status
0    000762.SZ  西藏矿业   20240927  涨停       锂矿、盐湖提锂     首板
1    300399.SZ  天利科技   20240927  涨停    互联网金融、金融概念     首板
2    002673.SZ  西部证券   20240927  涨停      证券、控参股基金     首板
3    002050.SZ  三花智控   20240927  涨停  汽车热管理、比亚迪产业链     首板
4    600801.SH  华新水泥   20240927  涨停        水泥、地产链     首板
..         ...   ...        ...  ..           ...    ...
126  600696.SH  岩石股份   20240927  涨停         白酒、酿酒    2连板
127  600606.SH  绿地控股   20240927  涨停       房地产、地产链    2连板
128  000882.SZ  华联股份   20240927  涨停      零售、互联网金融    2连板
129  000069.SZ  华侨城Ａ   20240927  涨停       房地产、地产链    2连板
130  002570.SZ   贝因美   20240927  涨停       多胎概念、乳业     首板

```
