# 柜台流通式债券最优报价

**文档ID**: 323
**原始链接**: https://tushare.pro/document/2?doc_id=323

---

## 柜台流通式债券最优报价

接口：bc_bestotcqt描述：柜台流通式债券最优报价限量：单次最大2000，可多次提取，总量不限制积分：用户需要至少500积分可以试用调取，2000积分以上频次相对较高，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>报价日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>报价日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>债券编码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>债券简称</td>
</tr>
<tr>
<td>remain_maturity</td>
<td>str</td>
<td>N</td>
<td>剩余期限</td>
</tr>
<tr>
<td>bond_type</td>
<td>str</td>
<td>N</td>
<td>债券类型</td>
</tr>
<tr>
<td>best_buy_bank</td>
<td>str</td>
<td>N</td>
<td>最优报买价方</td>
</tr>
<tr>
<td>best_buy_yield</td>
<td>float</td>
<td>N</td>
<td>投资者最优买入价到期收益率（%）</td>
</tr>
<tr>
<td>best_buy_price</td>
<td>float</td>
<td>N</td>
<td>投资者最优买入全价</td>
</tr>
<tr>
<td>best_sell_bank</td>
<td>str</td>
<td>N</td>
<td>最优卖报价方</td>
</tr>
<tr>
<td>best_sell_yield</td>
<td>float</td>
<td>N</td>
<td>投资者最优卖出价到期收益率（%）</td>
</tr>
<tr>
<td>best_sell_price</td>
<td>float</td>
<td>N</td>
<td>投资者最优卖出全价</td>
</tr>
</tbody></table>
接口示例

```
pro = ts.pro_api(your token)
#获取柜台流通式债券最优报价
df = pro.bc_bestotcqt(ts_code='200013.BC',start_date='20240325',end_date='20240329',fields='trade_date,ts_code,name,remain_maturity,best_buy_bank,best_buy_yield,best_sell_bank,best_sell_yield')

```

数据示例

```
    trade_date ts_code name remain_maturity best_buy_bank best_buy_yield best_sell_bank best_sell_yield
0   20240325  200013.BC  20附息国债13     1年211天       建设银行         1.9041        工商银行          1.9227
1   20240326  200013.BC  20附息国债13     1年210天       工商银行         1.8813        工商银行          1.9133
2   20240327  200013.BC  20附息国债13     1年209天       工商银行         1.8718        工商银行          1.9039
3   20240328  200013.BC  20附息国债13     1年208天       工商银行         1.8623        建设银行          1.8921
4   20240329  200013.BC  20附息国债13     1年207天       工商银行         1.8528        交通银行          1.8464

```
