# 柜台流通式债券报价

**文档ID**: 322
**原始链接**: https://tushare.pro/document/2?doc_id=322

---

## 柜台流通式债券报价

接口：bc_otcqt描述：柜台流通式债券报价限量：单次最大2000条，可多次提取，总量不限制积分：用户需要至少500积分可以试用调取，2000积分以上频次相对较高，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>bank</td>
<td>str</td>
<td>N</td>
<td>报价机构</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>报价日期</td>
</tr>
<tr>
<td>qt_time</td>
<td>str</td>
<td>N</td>
<td>报价时间</td>
</tr>
<tr>
<td>bank</td>
<td>str</td>
<td>N</td>
<td>报价机构</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>债券编码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>债券简称</td>
</tr>
<tr>
<td>maturity</td>
<td>str</td>
<td>N</td>
<td>期限</td>
</tr>
<tr>
<td>remain_maturity</td>
<td>str</td>
<td>N</td>
<td>剩余期限</td>
</tr>
<tr>
<td>bond_type</td>
<td>str</td>
<td>N</td>
<td>债券类型</td>
</tr>
<tr>
<td>coupon_rate</td>
<td>float</td>
<td>N</td>
<td>票面利率（%）</td>
</tr>
<tr>
<td>buy_price</td>
<td>float</td>
<td>N</td>
<td>投资者买入全价</td>
</tr>
<tr>
<td>sell_price</td>
<td>float</td>
<td>N</td>
<td>投资者卖出全价</td>
</tr>
<tr>
<td>buy_yield</td>
<td>float</td>
<td>N</td>
<td>投资者买入到期收益率（%）</td>
</tr>
<tr>
<td>sell_yield</td>
<td>float</td>
<td>N</td>
<td>投资者卖出到期收益率（%）</td>
</tr>
</tbody></table>
接口示例

```
pro = ts.pro_api(your token)
#柜台流通式债券报价
df = pro.bc_otcqt(start_date='20240325',end_date='20240329',ts_code='200013.BC',fields='trade_date,qt_time,bank,ts_code,name,remain_maturity,buy_yield,sell_yield')

```

数据示例

```
        trade_date   qt_time  bank    ts_code      name remain_maturity buy_yield sell_yield
0   20240329  08:11:02  浦发银行  200013.BC  20附息国债13          1年207天    1.9263     1.7977
1   20240329  09:05:28  招商银行  200013.BC  20附息国债13          1年207天    1.8950     1.8350
2   20240329  09:10:24  工商银行  200013.BC  20附息国债13          1年207天    1.8850     1.8528
3   20240329  09:14:48  建设银行  200013.BC  20附息国债13          1年207天    1.8837     1.8451
4   20240329  09:18:18  中国银行  200013.BC  20附息国债13          1年207天    1.9040     1.8200
5   20240329  10:40:09  北京银行  200013.BC  20附息国债13          1年207天    1.9043     1.8271
6   20240329  15:46:38  农业银行  200013.BC  20附息国债13          1年207天    1.8697     1.8054
7   20240329  18:36:29  交通银行  200013.BC  20附息国债13          1年207天    1.8464     1.8142

```
