# 机构调研数据

**文档ID**: 275
**原始链接**: https://tushare.pro/document/2?doc_id=275

---

## 机构调研表

接口：stk_surv描述：获取上市公司机构调研记录数据限量：单次最大获取100条数据，可循环或分页提取积分：用户积5000积分可使用

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>调研日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>调研开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>调研结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>surv_date</td>
<td>str</td>
<td>Y</td>
<td>调研日期</td>
</tr>
<tr>
<td>fund_visitors</td>
<td>str</td>
<td>Y</td>
<td>机构参与人员</td>
</tr>
<tr>
<td>rece_place</td>
<td>str</td>
<td>Y</td>
<td>接待地点</td>
</tr>
<tr>
<td>rece_mode</td>
<td>str</td>
<td>Y</td>
<td>接待方式</td>
</tr>
<tr>
<td>rece_org</td>
<td>str</td>
<td>Y</td>
<td>接待的公司</td>
</tr>
<tr>
<td>org_type</td>
<td>str</td>
<td>Y</td>
<td>接待公司类型</td>
</tr>
<tr>
<td>comp_rece</td>
<td>str</td>
<td>Y</td>
<td>上市公司接待人员</td>
</tr>
<tr>
<td>content</td>
<td>None</td>
<td>N</td>
<td>调研内容</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.stk_surv(ts_code='002223.SZ', trade_date='20211024', fields='ts_code,name,surv_date,fund_visitors,rece_place,rece_mode,rece_org')

```

数据样例

```
      ts_code  name  surv_date fund_visitors rece_place      rece_mode                          rece_org
1   002223.SZ  鱼跃医疗  20211024            郝淼       电话会议    特定对象调研                              宝盈基金
2   002223.SZ  鱼跃医疗  20211024           秦瑶函       电话会议    特定对象调研                           贝莱德资产管理
3   002223.SZ  鱼跃医疗  20211024            谭飞       电话会议    特定对象调研                              博远基金
4   002223.SZ  鱼跃医疗  20211024            李晗       电话会议    特定对象调研                            创金合信基金
..        ...   ...       ...           ...        ...       ...                               ...
77  002223.SZ  鱼跃医疗  20211024           李虹达       电话会议    特定对象调研                              中信建投
78  002223.SZ  鱼跃医疗  20211024           李明蔚       电话会议    特定对象调研                              中银国际
79  002223.SZ  鱼跃医疗  20211024            王俊       电话会议    特定对象调研                            重庆穿石投资
80  002223.SZ  鱼跃医疗  20211024            李扬       电话会议    特定对象调研                              朱雀基金
81  002223.SZ  鱼跃医疗  20211024           徐烨程       电话会议    特定对象调研                            逐流资产管理
```
