# 期货合约涨跌停价格

**文档ID**: 368
**原始链接**: https://tushare.pro/document/2?doc_id=368

---

## 期货合约涨跌停价格（盘前）

接口：ft_limit描述：获取所有期货合约每天的涨跌停价格及最低保证金率，数据开始于2005年。限量：单次最大获取4000行数据，可以通过日期、合约代码等参数循环获取所有历史积分：用户积5000积分可调取，积分获取方法具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>合约代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>cont</td>
<td>str</td>
<td>N</td>
<td>合约代码（例如：cont='CU')</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码 （例如：exchange='DCE')</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>合约名称</td>
</tr>
<tr>
<td>up_limit</td>
<td>float</td>
<td>Y</td>
<td>涨停价</td>
</tr>
<tr>
<td>down_limit</td>
<td>float</td>
<td>Y</td>
<td>跌停价</td>
</tr>
<tr>
<td>m_ratio</td>
<td>float</td>
<td>Y</td>
<td>最低交易保证金率（%）</td>
</tr>
<tr>
<td>cont</td>
<td>str</td>
<td>Y</td>
<td>合约代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所代码</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取单日全部期货合约涨跌停价格
df = pro.ft_limit(trade_date='20250213')

#获取单个品种所有合约涨跌停价格
df = pro.ft_limit(cont='CU')


```

数据样例

```
    trade_date     ts_code     name      up_limit down_limit m_ratio cont exchange
0     20250213   A2503.DCE  连豆一2503   4229.000   3751.000   7.000    A      DCE
1     20250213   A2505.DCE  连豆一2505   4249.000   3769.000   7.000    A      DCE
2     20250213   A2507.DCE  连豆一2507   4258.000   3776.000   7.000    A      DCE
3     20250213   A2509.DCE  连豆一2509   4268.000   3786.000   7.000    A      DCE
4     20250213   A2511.DCE  连豆一2511   4234.000   3756.000   7.000    A      DCE
..         ...         ...      ...        ...        ...     ...  ...      ...
783   20250213  ZN2509.SHF   沪锌2509  24890.000  21635.000   9.000   ZN     SHFE
784   20250213  ZN2510.SHF   沪锌2510  24885.000  21630.000   9.000   ZN     SHFE
785   20250213  ZN2511.SHF   沪锌2511  24780.000  21535.000   9.000   ZN     SHFE
786   20250213  ZN2512.SHF   沪锌2512  24700.000  21465.000   9.000   ZN     SHFE
787   20250213  ZN2601.SHF   沪锌2601  24710.000  21475.000   9.000   ZN     SHFE

```
