# 期货主要品种交易周报

**文档ID**: 216
**原始链接**: https://tushare.pro/document/2?doc_id=216

---

## 期货主要品种交易周报

接口：fut_weekly_detail描述：获取期货交易所主要品种每周交易统计信息，数据从2010年3月开始权限：600积分可调取，单次最大获取4000行数据，积分越高频次越高，5000积分以上正常调取不受限制数据来源：中国证监会，本数据由Tushare社区成员CE完成规划和采集

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>week</td>
<td>str</td>
<td>N</td>
<td>周期（每年第几周，e.g. 202001 表示2020第1周）</td>
</tr>
<tr>
<td>prd</td>
<td>str</td>
<td>N</td>
<td>期货品种（支持多品种输入，逗号分隔）</td>
</tr>
<tr>
<td>start_week</td>
<td>str</td>
<td>N</td>
<td>开始周期</td>
</tr>
<tr>
<td>end_week</td>
<td>str</td>
<td>N</td>
<td>结束周期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所（请参考<a href="https://tushare.pro/document/2?doc_id=134">交易所说明</a>）</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>提取的字段，e.g. fields='prd,name,vol'</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所代码</td>
</tr>
<tr>
<td>prd</td>
<td>str</td>
<td>Y</td>
<td>期货品种代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>品种名称</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量（手）</td>
</tr>
<tr>
<td>vol_yoy</td>
<td>float</td>
<td>Y</td>
<td>同比增减（%）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额（亿元）</td>
</tr>
<tr>
<td>amout_yoy</td>
<td>float</td>
<td>Y</td>
<td>同比增减（%）</td>
</tr>
<tr>
<td>cumvol</td>
<td>int</td>
<td>Y</td>
<td>年累计成交总量（手）</td>
</tr>
<tr>
<td>cumvol_yoy</td>
<td>float</td>
<td>Y</td>
<td>同比增减（%）</td>
</tr>
<tr>
<td>cumamt</td>
<td>float</td>
<td>Y</td>
<td>年累计成交金额（亿元）</td>
</tr>
<tr>
<td>cumamt_yoy</td>
<td>float</td>
<td>Y</td>
<td>同比增减（%）</td>
</tr>
<tr>
<td>open_interest</td>
<td>int</td>
<td>Y</td>
<td>持仓量（手）</td>
</tr>
<tr>
<td>interest_wow</td>
<td>float</td>
<td>Y</td>
<td>环比增减（%）</td>
</tr>
<tr>
<td>mc_close</td>
<td>float</td>
<td>Y</td>
<td>本周主力合约收盘价</td>
</tr>
<tr>
<td>close_wow</td>
<td>float</td>
<td>Y</td>
<td>环比涨跌（%）</td>
</tr>
<tr>
<td>week</td>
<td>str</td>
<td>Y</td>
<td>周期</td>
</tr>
<tr>
<td>week_date</td>
<td>str</td>
<td>Y</td>
<td>周日期</td>
</tr>
</tbody></table>
接口示例

```

#获取期货铜每周交易统计信息
df = pro.fut_weekly_detail(prd='CU')

#获取期货铜每周交易统计信息
df = pro.fut_weekly_detail(prd='CU', start_week='202001', end_week='202003', fields='prd,name,vol,amount')

```

数据示例

```
     exchange prd name        vol   vol_yoy       amount  amout_yoy    cumvol  \
0       SHFE  CU    铜  1078970.0    5.9664  2363.843445    -5.7003   6848849   
1       SHFE  CU    铜   719180.0  -39.2551  1629.243739   -44.6199   5769879   
2       SHFE  CU    铜   853051.0  -18.3270  1939.496318   -25.9779   5050699   
3       SHFE  CU    铜   631162.0  -31.7424  1461.354730   -35.9592   4197648   
4       SHFE  CU    铜   578056.0   -9.3746  1322.589156   -14.0750   3566486   
5       SHFE  CU    铜   730785.0   -6.5397  1660.914895   -11.1342   2988430   
6       SHFE  CU    铜   527482.0  -26.9089  1282.416054   -25.2899   2257645   
7       SHFE  CU    铜   705489.0  -23.1581  1734.699836   -19.9661   1730163   
8       SHFE  CU    铜   708250.0  -26.6082  1729.664611   -24.3423   1024674   
9       SHFE  CU    铜   658216.0  -14.7655  1621.641588   -10.9408  36830247   
10      SHFE  CU    铜  1044471.0    1.0854  2620.159590    -4.1661   6765968   
11      SHFE  CU    铜   924676.0  142.4229  2281.911847   123.2715   5721497   
12      SHFE  CU    铜   637852.0   12.2380  1539.237496     4.3256   4796821   
13      SHFE  CU    铜   744155.0  -16.7387  1840.043986   -14.4320  36172031   
14      SHFE  CU    铜   853989.0   -7.5109  2097.493940    -6.3866  35427876   
15      SHFE  CU    铜  1198852.0   62.8039  2915.899164    61.1575  34573887   
16      SHFE  CU    铜   781920.0  -21.2678  1869.015441   -29.4290   4158969   
17      SHFE  CU    铜   534402.0  -45.4224  1260.985602   -48.0350  33375035   
18      SHFE  CU    铜   548735.0  -52.4718  1296.078577   -54.3935  32840633   
19      SHFE  CU    铜   509696.0  -46.3713  1197.544717   -49.1703  32291898   
20      SHFE  CU    铜   598537.0  -35.6818  1408.258269   -38.4052  31782202   

     cumvol_yoy         cumamt  cumamt_yoy  open_interest  interest_wow  \
0      -23.6312   15901.272297    -26.8907         404849        5.4921   
1      -27.4220   13537.428852    -29.6511         383772        4.0396   
2      -25.3514   11908.185114    -26.9496         368871        3.2304   
3      -26.6337    9968.688796    -27.1357         357328        1.4024   
4      -25.6490    8507.334067    -25.3694         352386       11.7232   
5      -28.1449    7184.744911    -27.1326         315410       16.4089   
6      -33.1474    5523.830016    -30.8745         270950       -8.5351   
7      -34.8429    4241.413962    -32.4022         296234       -2.5203   
8      -41.0180    2506.714126    -38.9653         303893        3.5125   
9      -29.1989   88012.598030    -33.1154         293581      -11.9243   
10     -15.0339   16301.336253    -23.4456         335685        1.0746   
11     -17.4373   13681.176663    -26.2857         332116        8.1808   
12     -26.7487   11399.264817    -35.0014         307001        5.9925   
13     -29.4164   86390.956443    -33.4266         333328        9.7672   
14     -29.6414   84550.912457    -33.7467         303668       -0.8305   
15     -30.0548   82453.418517    -34.2356         306211       18.2994   
16      -9.9760    9860.027321    -21.0060         289644       -3.5256   
17     -31.4591   79537.519353    -35.6324         258844        0.1846   
18     -31.1725   78276.533751    -35.3840         258367       -4.1665   
19     -30.6444   76980.455175    -34.9273         269600       -0.1237   
20     -30.3166   75782.910458    -34.6379         269934        2.0379  

     mc_close  close_wow    week week_date  
0     43520.0    -3.2028  202011  20200313  
1     44900.0     0.2008  202010  20200306  
2     44390.0    -3.9177  202009  20200228  
3     45990.0    -0.1303  202008  20200221  
4     45930.0     0.4593  202007  20200214  
5     45690.0    -5.1287  202006  20200207  
6     48020.0    -2.6556  202004  20200124  
7     49250.0     0.6334  202003  20200117  
8     49010.0    -0.1223  202002  20200110  
9     48900.0    -1.8269  202001  20200103  
10    50500.0     1.5892   20199  20190301  
11    49920.0     3.2472   20198  20190222  
12    48200.0    -0.0829   20197  20190215  
13    49730.0     1.0156  201952  20191227  
14    49030.0    -0.0204  201951  20191220  
15    49010.0     3.4621  201950  20191213  
16    48270.0     2.0507   20195  20190201  
17    47320.0     0.0846  201949  20191206  
18    47320.0     0.8955  201948  20191129  
19    46870.0     0.0000  201947  20191122  
20    46930.0    -1.0959  201946  20191115  
```
