# 期权日线行情

**文档ID**: 159
**原始链接**: https://tushare.pro/document/2?doc_id=159

---

## 期权日线行情

接口：opt_daily描述：获取期权日线行情限量：单次最大15000条数据，可跟进日线或者代码循环，总量不限制积分：用户需要至少2000积分才可以调取，但有流量控制，请自行提高积分，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS合约代码（输入代码或时间至少任意一个参数）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所(SSE/SZSE/CFFEX/DCE/SHFE/CZCE）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易市场</td>
</tr>
<tr>
<td>pre_settle</td>
<td>float</td>
<td>Y</td>
<td>昨结算价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>前收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>settle</td>
<td>float</td>
<td>Y</td>
<td>结算价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量(手)</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额(万元)</td>
</tr>
<tr>
<td>oi</td>
<td>float</td>
<td>Y</td>
<td>持仓量(手)</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api('your token')

df = pro.opt_daily(trade_date='20181212')

```

数据示例

```
        ts_code trade_date exchange  ...      vol       amount       oi
0         10001313.SH   20181212      SSE  ...  38354.0  1261.435472  98882.0
1         10001314.SH   20181212      SSE  ...  14472.0   234.933288  79980.0
2         10001315.SH   20181212      SSE  ...  10092.0    69.311776  72370.0
3         10001316.SH   20181212      SSE  ...   5434.0    16.107224  55117.0
4         10001317.SH   20181212      SSE  ...   4240.0     5.798919  61746.0
..                ...        ...      ...  ...      ...          ...      ...
753  M1911-P-2900.DCE   20181212      DCE  ...      0.0     0.000000     20.0
754  M1911-P-2950.DCE   20181212      DCE  ...      0.0     0.000000     20.0
755  M1911-P-3000.DCE   20181212      DCE  ...      0.0     0.000000     20.0
756  M1911-P-3050.DCE   20181212      DCE  ...      0.0     0.000000     20.0
757  M1911-P-3100.DCE   20181212      DCE  ...      0.0     0.000000      0.0

```
