# 期权合约信息

**文档ID**: 158
**原始链接**: https://tushare.pro/document/2?doc_id=158

---

## 期权合约信息

接口：opt_basic描述：获取期权合约信息积分：用户需要至少5000积分可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS期权代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码 （包括上交所SSE等<a href="https://tushare.pro/document/2?doc_id=157">交易所</a>）</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>N</td>
<td>上市交易日</td>
</tr>
<tr>
<td>opt_code</td>
<td>str</td>
<td>N</td>
<td>标准合约代码，OP+期货合约TS_CODE，如棕榈油2207合约，输入OPP2207.DCE</td>
</tr>
<tr>
<td>call_put</td>
<td>str</td>
<td>N</td>
<td>期权类型</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易市场</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>合约名称</td>
</tr>
<tr>
<td>per_unit</td>
<td>str</td>
<td>Y</td>
<td>合约单位</td>
</tr>
<tr>
<td>opt_code</td>
<td>str</td>
<td>Y</td>
<td>标的合约代码</td>
</tr>
<tr>
<td>opt_type</td>
<td>str</td>
<td>Y</td>
<td>合约类型</td>
</tr>
<tr>
<td>call_put</td>
<td>str</td>
<td>Y</td>
<td>期权类型</td>
</tr>
<tr>
<td>exercise_type</td>
<td>str</td>
<td>Y</td>
<td>行权方式</td>
</tr>
<tr>
<td>exercise_price</td>
<td>float</td>
<td>Y</td>
<td>行权价格</td>
</tr>
<tr>
<td>s_month</td>
<td>str</td>
<td>Y</td>
<td>结算月</td>
</tr>
<tr>
<td>maturity_date</td>
<td>str</td>
<td>Y</td>
<td>到期日</td>
</tr>
<tr>
<td>list_price</td>
<td>float</td>
<td>Y</td>
<td>挂牌基准价</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>开始交易日期</td>
</tr>
<tr>
<td>delist_date</td>
<td>str</td>
<td>Y</td>
<td>最后交易日期</td>
</tr>
<tr>
<td>last_edate</td>
<td>str</td>
<td>Y</td>
<td>最后行权日期</td>
</tr>
<tr>
<td>last_ddate</td>
<td>str</td>
<td>Y</td>
<td>最后交割日期</td>
</tr>
<tr>
<td>quote_unit</td>
<td>str</td>
<td>Y</td>
<td>报价单位</td>
</tr>
<tr>
<td>min_price_chg</td>
<td>str</td>
<td>Y</td>
<td>最小价格波幅</td>
</tr>
</tbody>
</table>
接口示例

```
pro = ts.pro_api('your token')

df = pro.opt_basic(exchange='DCE', fields='ts_code,name,exercise_type,list_date,delist_date')

```

数据示例

```
          ts_code            name             exercise_type list_date delist_date
0    M1707-C-2400.DCE  豆粕期权1707认购2400            美式  20170605    20170607
1    M1707-P-2400.DCE  豆粕期权1707认沽2400            美式  20170605    20170607
2    M1803-P-2550.DCE  豆粕期权1803认沽2550            美式  20170407    20180207
3    M1707-C-2500.DCE  豆粕期权1707认购2500            美式  20170410    20170607
4    M1707-P-2500.DCE  豆粕期权1707认沽2500            美式  20170410    20170607
5    M1803-C-2550.DCE  豆粕期权1803认购2550            美式  20170407    20180207
6    M1808-C-3550.DCE  豆粕期权1808认购3550            美式  20180409    20180706
7    M1808-P-3550.DCE  豆粕期权1808认沽3550            美式  20180409    20180706
8    M1809-C-3550.DCE  豆粕期权1809认购3550            美式  20180409    20180807
9    M1809-P-3550.DCE  豆粕期权1809认沽3550            美式  20180409    20180807
10   M1811-C-3550.DCE  豆粕期权1811认购3550            美式  20180409    20181012
11   M1811-P-3550.DCE  豆粕期权1811认沽3550            美式  20180409    20181012
12   M1812-C-3500.DCE  豆粕期权1812认购3500            美式  20180409    20181107
13   M1812-C-3550.DCE  豆粕期权1812认购3550            美式  20180409    20181107
14   M1711-P-2450.DCE  豆粕期权1711认沽2450            美式  20170601    20171013
15   M1712-C-2450.DCE  豆粕期权1712认购2450            美式  20170601    20171107
16   M1712-P-2450.DCE  豆粕期权1712认沽2450            美式  20170601    20171107
17   M1801-C-2450.DCE  豆粕期权1801认购2450            美式  20170601    20171207
18   M1801-P-2450.DCE  豆粕期权1801认沽2450            美式  20170601    20171207
19   M1803-C-2450.DCE  豆粕期权1803认购2450            美式  20170601    20180207
20   M1803-P-2450.DCE  豆粕期权1803认沽2450            美式  20170601    20180207

```
