# 期权分钟行情

**文档ID**: 341
**原始链接**: https://tushare.pro/document/2?doc_id=341

---

## 期权历史分钟行情

接口：opt_mins描述：获取全市场期权合约分钟数据，支持1min/5min/15min/30min/60min行情，提供Python SDK和 http Restful API两种方式。限量：单次最大8000行数据，可以通过合约代码和时间循环获取。权限：120积分可以调取2次接口查看数据，正式权限请参阅权限说明。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码，e.g：10007976.SH</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>分钟频度（1min/5min/15min/30min/60min）</td>
</tr>
<tr>
<td>start_date</td>
<td>datetime</td>
<td>N</td>
<td>开始日期 格式：2024-08-25 09:00:00</td>
</tr>
<tr>
<td>end_date</td>
<td>datetime</td>
<td>N</td>
<td>结束时间 格式：2024-08-25 19:00:00</td>
</tr>
</tbody></table>
freq参数说明

<table>
<thead>
<tr>
<th>freq</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1min</td>
<td>1分钟</td>
</tr>
<tr>
<td>5min</td>
<td>5分钟</td>
</tr>
<tr>
<td>15min</td>
<td>15分钟</td>
</tr>
<tr>
<td>30min</td>
<td>30分钟</td>
</tr>
<tr>
<td>60min</td>
<td>60分钟</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额</td>
</tr>
<tr>
<td>oi</td>
<td>float</td>
<td>Y</td>
<td>持仓量</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.df = pro.opt_mins(ts_code='10007976.SH', freq='1min', start_date='2024-09-27 09:00:00', end_date='2024-09-27 19:00:00')

```

数据样例

```
     ts_code               trade_time    open   close    high     low    vol    amount      oi
0    10007976.SH  2024-09-27T15:00:00  0.1267  0.1370  0.1370  0.1267   44.0   60280.0  6499.0
1    10007976.SH  2024-09-27T14:59:00  0.1267  0.1267  0.1267  0.1267    0.0       0.0  6480.0
2    10007976.SH  2024-09-27T14:58:00  0.1267  0.1267  0.1267  0.1267    0.0       0.0  6480.0
3    10007976.SH  2024-09-27T14:57:00  0.1207  0.1267  0.1267  0.1207   25.0   31585.0  6480.0
4    10007976.SH  2024-09-27T14:56:00  0.1199  0.1207  0.1235  0.1194  259.0  312561.0  6464.0
..           ...                  ...     ...     ...     ...     ...    ...       ...     ...
236  10007976.SH  2024-09-27T09:34:00  0.0386  0.0386  0.0386  0.0386    0.0       0.0    86.0
237  10007976.SH  2024-09-27T09:33:00  0.0386  0.0386  0.0386  0.0386    0.0       0.0    86.0
238  10007976.SH  2024-09-27T09:32:00  0.0352  0.0386  0.0386  0.0348    6.0    2224.0    86.0
239  10007976.SH  2024-09-27T09:31:00  0.0261  0.0352  0.0368  0.0261   76.0   24668.0    80.0
240  10007976.SH  2024-09-27T09:30:00  0.0254  0.0254  0.0254  0.0254    4.0    1016.0     4.0

```
